/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.configuration.type.number;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.type.number.OptionalNumSerializer;
import java.lang.reflect.AnnotatedType;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.spongepowered.configurate.serialize.ScalarSerializer;

public interface IntOr {
    public static final Logger LOGGER = LogUtils.getClassLogger();

    default public int or(int fallback) {
        return this.value().orElse(fallback);
    }

    public OptionalInt value();

    default public boolean isDefined() {
        return this.value().isPresent();
    }

    default public int intValue() {
        return this.value().orElseThrow();
    }

    public static final class Serializer<T extends IntOr>
    extends OptionalNumSerializer<T, OptionalInt> {
        private Serializer(Class<T> classOfT, Function<OptionalInt, T> factory, String emptySerializedValue, T emptyValue) {
            super(classOfT, emptySerializedValue, emptyValue, OptionalInt::empty, OptionalInt::isEmpty, factory, Integer.TYPE);
        }

        @Override
        protected OptionalInt full(String value) {
            return OptionalInt.of(Integer.parseInt(value));
        }

        @Override
        protected OptionalInt full(Number num) {
            if ((double)num.intValue() != num.doubleValue() || (long)num.intValue() != num.longValue()) {
                LOGGER.error("{} cannot be converted to an integer without losing information", (Object)num);
            }
            return OptionalInt.of(num.intValue());
        }

        @Override
        protected boolean belowZero(OptionalInt value) {
            Preconditions.checkArgument((boolean)value.isPresent());
            return value.getAsInt() < 0;
        }

        protected Object serialize(AnnotatedType type, T item, Predicate<Class<?>> typeSupported) {
            OptionalInt value = item.value();
            if (value.isPresent()) {
                return value.getAsInt();
            }
            return this.emptySerializedValue;
        }
    }

    public record Disabled(OptionalInt value) implements IntOr
    {
        public static final Disabled DISABLED = new Disabled(OptionalInt.empty());
        private static final String DISABLED_VALUE = "disabled";
        public static final ScalarSerializer<Disabled> SERIALIZER = new Serializer<Disabled>(Disabled.class, Disabled::new, "disabled", DISABLED);

        public boolean test(IntPredicate predicate) {
            return this.value.isPresent() && predicate.test(this.value.getAsInt());
        }

        public boolean enabled() {
            return this.value.isPresent();
        }
    }

    public record Default(OptionalInt value) implements IntOr
    {
        public static final Default USE_DEFAULT = new Default(OptionalInt.empty());
        private static final String DEFAULT_VALUE = "default";
        public static final ScalarSerializer<Default> SERIALIZER = new Serializer<Default>(Default.class, Default::new, "default", USE_DEFAULT);
    }
}

