/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.jspecify.annotations.NullMarked;

@NullMarked
public interface PluginMessageBridgeImpl {
    public static final boolean DISABLE_CHANNEL_LIMIT = System.getProperty("paper.disableChannelLimit") != null;

    default public boolean addChannel(String channel) {
        Preconditions.checkState((DISABLE_CHANNEL_LIMIT || this.channels().size() < 128 ? 1 : 0) != 0, (Object)"Cannot register channel. Too many channels registered!");
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels().add(channel)) {
            PluginMessageBridgeImpl pluginMessageBridgeImpl = this;
            if (pluginMessageBridgeImpl instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)pluginMessageBridgeImpl;
                Bukkit.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)player, channel));
            }
            return true;
        }
        return false;
    }

    default public boolean removeChannel(String channel) {
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels().remove(channel)) {
            PluginMessageBridgeImpl pluginMessageBridgeImpl = this;
            if (pluginMessageBridgeImpl instanceof CraftPlayer) {
                CraftPlayer player = (CraftPlayer)pluginMessageBridgeImpl;
                Bukkit.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)player, channel));
            }
            return true;
        }
        return false;
    }

    public Set<String> channels();
}

