/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.bukkit.craftbukkit.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.util.Handleable;

public record PaperItemEnchantments(net.minecraft.world.item.enchantment.ItemEnchantments impl, Map<org.bukkit.enchantments.Enchantment, Integer> enchantments) implements ItemEnchantments,
Handleable<net.minecraft.world.item.enchantment.ItemEnchantments>
{
    public PaperItemEnchantments(net.minecraft.world.item.enchantment.ItemEnchantments itemEnchantments) {
        this(itemEnchantments, PaperItemEnchantments.convert(itemEnchantments));
    }

    private static Map<org.bukkit.enchantments.Enchantment, Integer> convert(net.minecraft.world.item.enchantment.ItemEnchantments itemEnchantments) {
        if (itemEnchantments.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<org.bukkit.enchantments.Enchantment, Integer> map = new HashMap<org.bukkit.enchantments.Enchantment, Integer>(itemEnchantments.size());
        for (Object2IntMap.Entry<Holder<Enchantment>> entry : itemEnchantments.entrySet()) {
            map.put(CraftEnchantment.minecraftHolderToBukkit((Holder)entry.getKey()), entry.getIntValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public net.minecraft.world.item.enchantment.ItemEnchantments getHandle() {
        return this.impl;
    }

    static final class BuilderImpl
    implements ItemEnchantments.Builder {
        private final Map<org.bukkit.enchantments.Enchantment, Integer> enchantments = new Object2ObjectOpenHashMap();

        BuilderImpl() {
        }

        public ItemEnchantments.Builder add(org.bukkit.enchantments.Enchantment enchantment, int level) {
            Preconditions.checkArgument((level >= 1 && level <= 255 ? 1 : 0) != 0, (String)"level must be between %s and %s, was %s", (Object)1, (Object)255, (Object)level);
            this.enchantments.put(enchantment, level);
            return this;
        }

        public ItemEnchantments.Builder addAll(Map<org.bukkit.enchantments.Enchantment, Integer> enchantments) {
            enchantments.forEach(this::add);
            return this;
        }

        public ItemEnchantments build() {
            net.minecraft.world.item.enchantment.ItemEnchantments initialEnchantments = net.minecraft.world.item.enchantment.ItemEnchantments.EMPTY;
            if (this.enchantments.isEmpty()) {
                return new PaperItemEnchantments(initialEnchantments);
            }
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(initialEnchantments);
            this.enchantments.forEach((enchantment, level) -> mutable.set(CraftEnchantment.bukkitToMinecraftHolder(enchantment), (int)level));
            return new PaperItemEnchantments(mutable.toImmutable());
        }
    }
}

