/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent.item;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.datacomponent.item.KineticWeapon;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.component.KineticWeapon;
import org.bukkit.craftbukkit.util.Handleable;
import org.jspecify.annotations.Nullable;

public record PaperKineticWeapon(net.minecraft.world.item.component.KineticWeapon impl) implements KineticWeapon,
Handleable<net.minecraft.world.item.component.KineticWeapon>
{
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static KineticWeapon.Condition toNms(KineticWeapon.Condition api) {
        if (!(api instanceof PaperKineticWeaponCondition)) throw new UnsupportedOperationException("Could not decode " + String.valueOf(api));
        PaperKineticWeaponCondition paperKineticWeaponCondition = (PaperKineticWeaponCondition)api;
        try {
            KineticWeapon.Condition condition = paperKineticWeaponCondition.impl();
            return condition;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public net.minecraft.world.item.component.KineticWeapon getHandle() {
        return this.impl;
    }

    public int contactCooldownTicks() {
        return this.impl.contactCooldownTicks();
    }

    public int delayTicks() {
        return this.impl.delayTicks();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KineticWeapon.Condition dismountConditions() {
        return this.impl.dismountConditions().map(PaperKineticWeaponCondition::new).orElse(null);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KineticWeapon.Condition knockbackConditions() {
        return this.impl.knockbackConditions().map(PaperKineticWeaponCondition::new).orElse(null);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable KineticWeapon.Condition damageConditions() {
        return this.impl.damageConditions().map(PaperKineticWeaponCondition::new).orElse(null);
    }

    public float forwardMovement() {
        return this.impl.forwardMovement();
    }

    public float damageMultiplier() {
        return this.impl.damageMultiplier();
    }

    public @Nullable Key sound() {
        return this.impl.sound().map(Holder::value).map(SoundEvent::location).map(PaperAdventure::asAdventure).orElse(null);
    }

    public @Nullable Key hitSound() {
        return this.impl.hitSound().map(Holder::value).map(SoundEvent::location).map(PaperAdventure::asAdventure).orElse(null);
    }

    public record PaperKineticWeaponCondition(KineticWeapon.Condition impl) implements KineticWeapon.Condition,
    Handleable<KineticWeapon.Condition>
    {
        @Override
        public KineticWeapon.Condition getHandle() {
            return this.impl;
        }

        public int maxDurationTicks() {
            return this.impl.maxDurationTicks();
        }

        public float minSpeed() {
            return this.impl.minSpeed();
        }

        public float minRelativeSpeed() {
            return this.impl.minRelativeSpeed();
        }
    }

    static final class BuilderImpl
    implements KineticWeapon.Builder {
        private int contactCooldownTicks = 10;
        private int delayTicks = 0;
        private @Nullable KineticWeapon.Condition dismountConditions;
        private @Nullable KineticWeapon.Condition knockbackConditions;
        private @Nullable KineticWeapon.Condition damageConditions;
        private @Nullable Key sound = null;
        private @Nullable Key hitSound = null;
        private float damageMultiplier = 1.0f;
        private float forwardMovement = 0.0f;

        BuilderImpl() {
        }

        public KineticWeapon.Builder contactCooldownTicks(int ticks) {
            Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"contactCooldownTicks must be non-negative");
            this.contactCooldownTicks = ticks;
            return this;
        }

        public KineticWeapon.Builder delayTicks(int ticks) {
            Preconditions.checkArgument((ticks >= 0 ? 1 : 0) != 0, (Object)"delayTicks must be non-negative");
            this.delayTicks = ticks;
            return this;
        }

        public KineticWeapon.Builder dismountConditions(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable KineticWeapon.Condition condition) {
            this.dismountConditions = condition == null ? null : PaperKineticWeapon.toNms(condition);
            return this;
        }

        public KineticWeapon.Builder knockbackConditions(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable KineticWeapon.Condition condition) {
            this.knockbackConditions = condition == null ? null : PaperKineticWeapon.toNms(condition);
            return this;
        }

        public KineticWeapon.Builder damageConditions(// Could not load outer class - annotation placement on inner may be incorrect
        @Nullable KineticWeapon.Condition condition) {
            this.damageConditions = condition == null ? null : PaperKineticWeapon.toNms(condition);
            return this;
        }

        public KineticWeapon.Builder damageMultiplier(float damageMultiplier) {
            this.damageMultiplier = damageMultiplier;
            return this;
        }

        public KineticWeapon.Builder forwardMovement(float forwardMovement) {
            this.forwardMovement = forwardMovement;
            return this;
        }

        public KineticWeapon.Builder sound(@Nullable Key sound) {
            this.sound = sound;
            return this;
        }

        public KineticWeapon.Builder hitSound(@Nullable Key sound) {
            this.hitSound = sound;
            return this;
        }

        public KineticWeapon build() {
            return new PaperKineticWeapon(new net.minecraft.world.item.component.KineticWeapon(this.contactCooldownTicks, this.delayTicks, Optional.ofNullable(this.dismountConditions), Optional.ofNullable(this.knockbackConditions), Optional.ofNullable(this.damageConditions), this.forwardMovement, this.damageMultiplier, Optional.ofNullable(this.sound).map(PaperAdventure::resolveSound), Optional.ofNullable(this.hitSound).map(PaperAdventure::resolveSound)));
        }
    }
}

