/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.network;

import io.netty.channel.Channel;
import io.papermc.paper.network.ChannelInitializeListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ChannelInitializeListenerHolder {
    private static final Map<Key, ChannelInitializeListener> LISTENERS = new LinkedHashMap<Key, ChannelInitializeListener>();
    private static final Map<Key, ChannelInitializeListener> IMMUTABLE_VIEW = Collections.unmodifiableMap(LISTENERS);

    private ChannelInitializeListenerHolder() {
    }

    public static boolean hasListener(@NonNull Key key) {
        return LISTENERS.containsKey(key);
    }

    public static void addListener(@NonNull Key key, @NonNull ChannelInitializeListener listener) {
        LISTENERS.put(key, listener);
    }

    public static @Nullable ChannelInitializeListener removeListener(@NonNull Key key) {
        return LISTENERS.remove(key);
    }

    public static @NonNull Map<Key, ChannelInitializeListener> getListeners() {
        return IMMUTABLE_VIEW;
    }

    public static void callListeners(@NonNull Channel channel) {
        for (ChannelInitializeListener listener : LISTENERS.values()) {
            listener.afterInitChannel(channel);
        }
    }
}

