/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.manager;

import co.aikar.timings.TimedEventExecutor;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerEventException;
import com.destroystokyo.paper.exception.ServerException;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Server;
import org.bukkit.Warning;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.AuthorNagException;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.IllegalPluginAccessException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;

class PaperEventManager {
    private final Server server;

    public PaperEventManager(Server server) {
        this.server = server;
    }

    public void callEvent(@NotNull Event event) {
        RegisteredListener[] listeners;
        if (event.isAsynchronous() && this.server.isPrimaryThread()) {
            throw new IllegalStateException(event.getEventName() + " may only be triggered asynchronously.");
        }
        if (!(event.isAsynchronous() || this.server.isPrimaryThread() || this.server.isStopping())) {
            throw new IllegalStateException(event.getEventName() + " may only be triggered synchronously.");
        }
        HandlerList handlers = event.getHandlers();
        for (RegisteredListener registration : listeners = handlers.getRegisteredListeners()) {
            if (!registration.getPlugin().isEnabled()) continue;
            try {
                registration.callEvent(event);
            }
            catch (AuthorNagException ex) {
                Plugin plugin = registration.getPlugin();
                if (!plugin.isNaggable()) continue;
                plugin.setNaggable(false);
                this.server.getLogger().log(Level.SEVERE, String.format("Nag author(s): '%s' of '%s' about the following: %s", plugin.getPluginMeta().getAuthors(), plugin.getPluginMeta().getDisplayName(), ex.getMessage()));
            }
            catch (Throwable ex) {
                String msg = "Could not pass event " + event.getEventName() + " to " + registration.getPlugin().getPluginMeta().getDisplayName();
                this.server.getLogger().log(Level.SEVERE, msg, ex);
                if (event instanceof ServerExceptionEvent) continue;
                this.callEvent((Event)new ServerExceptionEvent((ServerException)new ServerEventException(msg, ex, registration.getPlugin(), registration.getListener(), event)));
            }
        }
    }

    public void registerEvents(@NotNull Listener listener, @NotNull Plugin plugin) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(listener) + " while not enabled");
        }
        for (Map.Entry<Class<? extends Event>, Set<RegisteredListener>> entry : this.createRegisteredListeners(listener, plugin).entrySet()) {
            this.getEventListeners(this.getRegistrationClass(entry.getKey())).registerAll((Collection)entry.getValue());
        }
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin) {
        this.registerEvent(event, listener, priority, executor, plugin, false);
    }

    public void registerEvent(@NotNull Class<? extends Event> event, @NotNull Listener listener, @NotNull EventPriority priority, @NotNull EventExecutor executor, @NotNull Plugin plugin, boolean ignoreCancelled) {
        if (!plugin.isEnabled()) {
            throw new IllegalPluginAccessException("Plugin attempted to register " + String.valueOf(event) + " while not enabled");
        }
        executor = new TimedEventExecutor(executor, plugin, null, event);
        this.getEventListeners(event).register(new RegisteredListener(listener, executor, priority, plugin, ignoreCancelled));
    }

    @NotNull
    private HandlerList getEventListeners(@NotNull Class<? extends Event> type) {
        try {
            Method method = this.getRegistrationClass(type).getDeclaredMethod("getHandlerList", new Class[0]);
            method.setAccessible(true);
            return (HandlerList)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalPluginAccessException(e.toString());
        }
    }

    @NotNull
    private Class<? extends Event> getRegistrationClass(@NotNull Class<? extends Event> clazz) {
        try {
            clazz.getDeclaredMethod("getHandlerList", new Class[0]);
            return clazz;
        }
        catch (NoSuchMethodException e) {
            if (clazz.getSuperclass() != null && !clazz.getSuperclass().equals(Event.class) && Event.class.isAssignableFrom(clazz.getSuperclass())) {
                return this.getRegistrationClass(clazz.getSuperclass().asSubclass(Event.class));
            }
            throw new IllegalPluginAccessException("Unable to find handler list for event " + clazz.getName() + ". Static getHandlerList method required!");
        }
    }

    @NotNull
    public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(@NotNull Listener listener, @NotNull Plugin plugin) {
        Sets.SetView methods;
        HashMap<Class<? extends Event>, Set<RegisteredListener>> ret = new HashMap<Class<? extends Event>, Set<RegisteredListener>>();
        try {
            Class listenerClazz = listener.getClass();
            methods = Sets.union(Set.of(listenerClazz.getMethods()), Set.of(listenerClazz.getDeclaredMethods()));
        }
        catch (NoClassDefFoundError e) {
            plugin.getLogger().severe("Failed to register events for " + String.valueOf(listener.getClass()) + " because " + e.getMessage() + " does not exist.");
            return ret;
        }
        for (Method method : methods) {
            Class<?> checkClass;
            EventHandler eh = method.getAnnotation(EventHandler.class);
            if (eh == null || method.isBridge() || method.isSynthetic()) continue;
            if (method.getParameterTypes().length != 1 || !Event.class.isAssignableFrom(checkClass = method.getParameterTypes()[0])) {
                plugin.getLogger().severe(plugin.getPluginMeta().getDisplayName() + " attempted to register an invalid EventHandler method signature \"" + method.toGenericString() + "\" in " + String.valueOf(listener.getClass()));
                continue;
            }
            Class<Event> eventClass = checkClass.asSubclass(Event.class);
            method.setAccessible(true);
            Set eventSet = ret.computeIfAbsent(eventClass, k -> new HashSet());
            Class<Event> clazz = eventClass;
            while (Event.class.isAssignableFrom(clazz)) {
                if (clazz.getAnnotation(Deprecated.class) != null) {
                    Warning warning = clazz.getAnnotation(Warning.class);
                    Warning.WarningState warningState = this.server.getWarningState();
                    if (!warningState.printFor(warning)) break;
                    plugin.getLogger().log(Level.WARNING, String.format("\"%s\" has registered a listener for %s on method \"%s\", but the event is Deprecated. \"%s\"; please notify the authors %s.", plugin.getPluginMeta().getDisplayName(), clazz.getName(), method.toGenericString(), warning != null && warning.reason().length() != 0 ? warning.reason() : "Server performance will be affected", Arrays.toString(plugin.getPluginMeta().getAuthors().toArray())), warningState == Warning.WarningState.ON ? new AuthorNagException(null) : null);
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            TimedEventExecutor executor = new TimedEventExecutor(EventExecutor.create((Method)method, eventClass), plugin, method, eventClass);
            eventSet.add(new RegisteredListener(listener, (EventExecutor)executor, eh.priority(), plugin, eh.ignoreCancelled()));
        }
        return ret;
    }

    public void clearEvents() {
        HandlerList.unregisterAll();
    }
}

