/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.type.spigot;

import com.destroystokyo.paper.utils.PaperPluginLogger;
import io.papermc.paper.plugin.bootstrap.PluginProviderContextImpl;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.entrypoint.classloader.BytecodeModifyingURLClassLoader;
import io.papermc.paper.plugin.entrypoint.classloader.PaperSimplePluginClassLoader;
import io.papermc.paper.plugin.loader.PaperClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginClasspathBuilder;
import io.papermc.paper.plugin.loader.PluginLoader;
import io.papermc.paper.plugin.provider.configuration.serializer.constraints.PluginConfigConstraints;
import io.papermc.paper.plugin.provider.type.PluginTypeFactory;
import io.papermc.paper.plugin.provider.type.spigot.SpigotPluginProvider;
import io.papermc.paper.plugin.provider.util.ProviderUtil;
import io.papermc.paper.util.MappingEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.LibraryLoader;
import org.yaml.snakeyaml.error.YAMLException;

class SpigotPluginProviderFactory
implements PluginTypeFactory<SpigotPluginProvider, PluginDescriptionFile> {
    SpigotPluginProviderFactory() {
    }

    @Override
    public SpigotPluginProvider build(JarFile file, PluginDescriptionFile configuration, Path source) throws InvalidDescriptionException {
        List<Path> paperLibraryPaths;
        String name = configuration.getRawName();
        if (PluginConfigConstraints.RESERVED_KEYS.contains(name.toLowerCase(Locale.ROOT))) {
            throw new InvalidDescriptionException("Restricted name, cannot use %s as a plugin name.".formatted(name));
        }
        if (name.indexOf(32) != -1) {
            throw new InvalidDescriptionException("Restricted name, cannot use 0x20 (space character) in a plugin name.");
        }
        if (configuration.getPaperPluginLoader() != null) {
            Logger logger = PaperPluginLogger.getLogger((PluginDescriptionFile)configuration);
            PaperClasspathBuilder builder = new PaperClasspathBuilder(PluginProviderContextImpl.create((PluginMeta)configuration, ComponentLogger.logger((String)logger.getName()), source));
            try (PaperSimplePluginClassLoader simplePluginClassLoader = new PaperSimplePluginClassLoader(source, file, (PluginMeta)configuration, this.getClass().getClassLoader());){
                PluginLoader loader = (PluginLoader)ProviderUtil.loadClass((String)configuration.getPaperPluginLoader(), PluginLoader.class, (ClassLoader)simplePluginClassLoader);
                loader.classloader((PluginClasspathBuilder)builder);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            paperLibraryPaths = builder.buildLibraryPaths(false);
        } else {
            paperLibraryPaths = null;
        }
        return new SpigotPluginProvider(source, file, configuration, paperLibraryPaths);
    }

    @Override
    public PluginDescriptionFile create(JarFile file, JarEntry config) throws InvalidDescriptionException {
        PluginDescriptionFile descriptionFile;
        try (InputStream inputStream = file.getInputStream(config);){
            descriptionFile = new PluginDescriptionFile(inputStream);
        }
        catch (IOException | YAMLException ex) {
            throw new InvalidDescriptionException(ex);
        }
        return descriptionFile;
    }

    static {
        if (!MappingEnvironment.DISABLE_PLUGIN_REMAPPING) {
            LibraryLoader.LIBRARY_LOADER_FACTORY = BytecodeModifyingURLClassLoader::new;
        }
    }
}

