/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistries;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.JukeboxSongRegistryEntry;
import io.papermc.paper.registry.data.PaperSoundEventRegistryEntry;
import io.papermc.paper.registry.data.SoundEventRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import io.papermc.paper.registry.holder.PaperRegistryHolders;
import io.papermc.paper.registry.holder.RegistryHolder;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import org.bukkit.Sound;
import org.checkerframework.checker.index.qual.Positive;
import org.jetbrains.annotations.Range;
import org.jspecify.annotations.Nullable;

public class PaperJukeboxSongRegistryEntry
implements JukeboxSongRegistryEntry {
    protected final Conversions conversions;
    protected @Nullable Holder<SoundEvent> soundEvent;
    protected @Nullable Component description;
    protected @Nullable Float lengthInSeconds;
    protected OptionalInt comparatorOutput = OptionalInt.empty();

    public PaperJukeboxSongRegistryEntry(Conversions conversions, @Nullable JukeboxSong internal) {
        this.conversions = conversions;
        if (internal == null) {
            return;
        }
        this.soundEvent = internal.soundEvent();
        this.description = internal.description();
        this.lengthInSeconds = Float.valueOf(internal.lengthInSeconds());
        this.comparatorOutput = OptionalInt.of(internal.comparatorOutput());
    }

    public RegistryHolder<Sound, SoundEventRegistryEntry> soundEvent() {
        Holder<SoundEvent> current = Checks.asConfigured(this.soundEvent, "soundEvent");
        return PaperRegistryHolders.create(current, e -> new PaperSoundEventRegistryEntry(this.conversions, (SoundEvent)e));
    }

    public net.kyori.adventure.text.Component description() {
        return this.conversions.asAdventure(Checks.asConfigured(this.description, "description"));
    }

    public float lengthInSeconds() {
        return Checks.asConfigured(this.lengthInSeconds, "lengthInSeconds").floatValue();
    }

    public int comparatorOutput() {
        return Checks.asConfigured(this.comparatorOutput, "comparatorOutput");
    }

    public static final class PaperBuilder
    extends PaperJukeboxSongRegistryEntry
    implements JukeboxSongRegistryEntry.Builder,
    PaperRegistryBuilder<JukeboxSong, org.bukkit.JukeboxSong> {
        public PaperBuilder(Conversions conversions, @Nullable JukeboxSong internal) {
            super(conversions, internal);
        }

        public JukeboxSongRegistryEntry.Builder soundEvent(TypedKey<Sound> soundEvent) {
            this.soundEvent = this.conversions.getReferenceHolder(PaperRegistries.toNms(Checks.asArgument(soundEvent, "soundEvent")));
            return this;
        }

        public JukeboxSongRegistryEntry.Builder soundEvent(Consumer<RegistryBuilderFactory<Sound, ? extends SoundEventRegistryEntry.Builder>> soundEvent) {
            this.soundEvent = this.conversions.createHolderFromBuilder(RegistryKey.SOUND_EVENT, Checks.asArgument(soundEvent, "soundEvent"));
            return this;
        }

        public JukeboxSongRegistryEntry.Builder soundEvent(RegistryHolder<Sound, SoundEventRegistryEntry> soundEvent) {
            this.soundEvent = PaperRegistryHolders.convert(soundEvent, this.conversions);
            return this;
        }

        public JukeboxSongRegistryEntry.Builder description(net.kyori.adventure.text.Component description) {
            this.description = this.conversions.asVanilla(Checks.asArgument(description, "description"));
            return this;
        }

        public JukeboxSongRegistryEntry.Builder lengthInSeconds(@Positive float lengthInSeconds) {
            this.lengthInSeconds = Float.valueOf(Checks.asArgumentMinExclusive(lengthInSeconds, "lengthInSeconds", 0.0f));
            return this;
        }

        public JukeboxSongRegistryEntry.Builder comparatorOutput(@Range(from=0L, to=15L) int comparatorOutput) {
            this.comparatorOutput = OptionalInt.of(Checks.asArgumentRange(comparatorOutput, "comparatorOutput", 0, 15));
            return this;
        }

        @Override
        public JukeboxSong build() {
            return new JukeboxSong(Checks.asConfigured(this.soundEvent, "soundEvent"), Checks.asConfigured(this.description, "description"), this.lengthInSeconds(), this.comparatorOutput());
        }
    }
}

