/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.SoundEventRegistryEntry;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvent;
import org.bukkit.Sound;
import org.jspecify.annotations.Nullable;

public class PaperSoundEventRegistryEntry
implements SoundEventRegistryEntry {
    protected final Conversions conversions;
    protected @Nullable Identifier location;
    protected @Nullable Float fixedRange;

    public PaperSoundEventRegistryEntry(Conversions conversions, @Nullable SoundEvent soundEvent) {
        this.conversions = conversions;
        if (soundEvent == null) {
            return;
        }
        this.location = soundEvent.location();
        this.fixedRange = soundEvent.fixedRange().orElse(null);
    }

    public Key location() {
        return PaperAdventure.asAdventure(Checks.asConfigured(this.location, "location"));
    }

    public @Nullable Float fixedRange() {
        return this.fixedRange;
    }

    public static final class PaperBuilder
    extends PaperSoundEventRegistryEntry
    implements SoundEventRegistryEntry.Builder,
    PaperRegistryBuilder<SoundEvent, Sound> {
        public PaperBuilder(Conversions conversions, @Nullable SoundEvent soundEvent) {
            super(conversions, soundEvent);
        }

        public SoundEventRegistryEntry.Builder location(Key location) {
            this.location = PaperAdventure.asVanilla(Checks.asArgument(location, "location"));
            return this;
        }

        public SoundEventRegistryEntry.Builder fixedRange(@Nullable Float fixedRange) {
            this.fixedRange = fixedRange;
            return this;
        }

        @Override
        public SoundEvent build() {
            return new SoundEvent(Checks.asConfigured(this.location, "location"), Optional.ofNullable(this.fixedRange));
        }
    }
}

