/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.PaperRegistryBuilder;
import io.papermc.paper.registry.data.ZombieNautilusVariantRegistryEntry;
import io.papermc.paper.registry.data.client.ClientTextureAsset;
import io.papermc.paper.registry.data.util.Checks;
import io.papermc.paper.registry.data.util.Conversions;
import net.minecraft.core.ClientAsset;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import org.bukkit.entity.ZombieNautilus;
import org.jspecify.annotations.Nullable;

public class PaperZombieNautilusVariantRegistryEntry
implements ZombieNautilusVariantRegistryEntry {
    protected @Nullable ZombieNautilusVariant.ModelType model;
    protected @Nullable ClientAsset.ResourceTexture clientTextureAsset;
    protected SpawnPrioritySelectors spawnConditions;
    protected final Conversions conversions;

    public PaperZombieNautilusVariantRegistryEntry(Conversions conversions, @Nullable ZombieNautilusVariant internal) {
        this.conversions = conversions;
        if (internal == null) {
            this.spawnConditions = SpawnPrioritySelectors.EMPTY;
            return;
        }
        this.clientTextureAsset = internal.modelAndTexture().asset();
        this.model = internal.modelAndTexture().model();
        this.spawnConditions = internal.spawnConditions();
    }

    public ClientTextureAsset clientTextureAsset() {
        return this.conversions.asBukkit(Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset"));
    }

    public ZombieNautilusVariantRegistryEntry.Model model() {
        return switch (Checks.asConfigured(this.model, "model")) {
            default -> throw new MatchException(null, null);
            case ZombieNautilusVariant.ModelType.NORMAL -> ZombieNautilusVariantRegistryEntry.Model.NORMAL;
            case ZombieNautilusVariant.ModelType.WARM -> ZombieNautilusVariantRegistryEntry.Model.WARM;
        };
    }

    public static final class PaperBuilder
    extends PaperZombieNautilusVariantRegistryEntry
    implements ZombieNautilusVariantRegistryEntry.Builder,
    PaperRegistryBuilder<ZombieNautilusVariant, ZombieNautilus.Variant> {
        public PaperBuilder(Conversions conversions, @Nullable ZombieNautilusVariant internal) {
            super(conversions, internal);
        }

        public ZombieNautilusVariantRegistryEntry.Builder clientTextureAsset(ClientTextureAsset clientTextureAsset) {
            this.clientTextureAsset = this.conversions.asVanilla(Checks.asArgument(clientTextureAsset, "clientTextureAsset"));
            return this;
        }

        public ZombieNautilusVariantRegistryEntry.Builder model(ZombieNautilusVariantRegistryEntry.Model model) {
            this.model = switch (Checks.asArgument(model, "model")) {
                default -> throw new MatchException(null, null);
                case ZombieNautilusVariantRegistryEntry.Model.NORMAL -> ZombieNautilusVariant.ModelType.NORMAL;
                case ZombieNautilusVariantRegistryEntry.Model.WARM -> ZombieNautilusVariant.ModelType.WARM;
            };
            return this;
        }

        @Override
        public ZombieNautilusVariant build() {
            return new ZombieNautilusVariant(new ModelAndTexture<ZombieNautilusVariant.ModelType>(Checks.asConfigured(this.model, "model"), Checks.asConfigured(this.clientTextureAsset, "clientTextureAsset")), Checks.asConfigured(this.spawnConditions, "spawnConditions"));
        }
    }
}

