/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data.dialog.body;

import com.google.common.base.Preconditions;
import io.papermc.paper.registry.data.dialog.body.ItemDialogBody;
import io.papermc.paper.registry.data.dialog.body.PlainMessageDialogBody;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.jspecify.annotations.Nullable;

public record ItemDialogBodyImpl(org.bukkit.inventory.ItemStack item, @Nullable PlainMessageDialogBody description, boolean showDecorations, boolean showTooltip, int width, int height) implements ItemDialogBody
{

    public static final class BuilderImpl
    implements ItemDialogBody.Builder {
        private final org.bukkit.inventory.ItemStack item;
        private @Nullable PlainMessageDialogBody description;
        private boolean showDecorations = true;
        private boolean showTooltip = true;
        private int width = 16;
        private int height = 16;

        public BuilderImpl(org.bukkit.inventory.ItemStack item) {
            ItemStack.validateStrict(CraftItemStack.unwrap(item)).getOrThrow();
            this.item = item;
        }

        public ItemDialogBody.Builder description(@Nullable PlainMessageDialogBody description) {
            this.description = description;
            return this;
        }

        public ItemDialogBody.Builder showDecorations(boolean showDecorations) {
            this.showDecorations = showDecorations;
            return this;
        }

        public ItemDialogBody.Builder showTooltip(boolean showTooltip) {
            this.showTooltip = showTooltip;
            return this;
        }

        public ItemDialogBody.Builder width(int width) {
            Preconditions.checkArgument((width >= 1 && width <= 256 ? 1 : 0) != 0, (Object)"Width must be between 1 and 256");
            this.width = width;
            return this;
        }

        public ItemDialogBody.Builder height(int height) {
            Preconditions.checkArgument((height >= 1 && height <= 256 ? 1 : 0) != 0, (Object)"Height must be between 1 and 256");
            this.height = height;
            return this;
        }

        public ItemDialogBody build() {
            return new ItemDialogBodyImpl(this.item, this.description, this.showDecorations, this.showTooltip, this.width, this.height);
        }
    }
}

