/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.tag;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.lifecycle.event.registrar.PaperRegistrar;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PreFlattenTagRegistrar;
import io.papermc.paper.tag.TagEntry;
import io.papermc.paper.tag.TagEntryImpl;
import io.papermc.paper.tag.TagEventConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.kyori.adventure.key.Key;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagLoader;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public class PaperPreFlattenTagRegistrar<T>
implements PaperRegistrar<BootstrapContext>,
PreFlattenTagRegistrar<T> {
    public final Map<Identifier, List<TagLoader.EntryWithSource>> tags;
    private final RegistryKey<T> registryKey;
    private @Nullable BootstrapContext owner;

    public PaperPreFlattenTagRegistrar(Map<Identifier, List<TagLoader.EntryWithSource>> tags, TagEventConfig<?, T> config) {
        this.tags = new HashMap<Identifier, List<TagLoader.EntryWithSource>>(tags);
        this.registryKey = config.apiRegistryKey();
    }

    @Override
    public void setCurrentContext(@Nullable BootstrapContext owner) {
        this.owner = owner;
    }

    public RegistryKey<T> registryKey() {
        return this.registryKey;
    }

    public Map<TagKey<T>, Collection<TagEntry<T>>> getAllTags() {
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)this.tags.size());
        for (Map.Entry<Identifier, List<TagLoader.EntryWithSource>> entry : this.tags.entrySet()) {
            TagKey key = TagKey.create(this.registryKey, (Key)CraftNamespacedKey.fromMinecraft(entry.getKey()));
            builder.put((Object)key, PaperPreFlattenTagRegistrar.convert(entry.getValue()));
        }
        return builder.build();
    }

    private static <T> List<TagEntry<T>> convert(List<TagLoader.EntryWithSource> nmsEntries) {
        return Collections.unmodifiableList(Lists.transform(nmsEntries, PaperPreFlattenTagRegistrar::convert));
    }

    private static <T> TagEntry<T> convert(TagLoader.EntryWithSource nmsEntry) {
        return new TagEntryImpl((Key)CraftNamespacedKey.fromMinecraft(nmsEntry.entry().id), nmsEntry.entry().tag, nmsEntry.entry().required);
    }

    private TagLoader.EntryWithSource convert(TagEntry<T> entry) {
        Preconditions.checkState((this.owner != null ? 1 : 0) != 0, (Object)"Owner is not set");
        Identifier vanilla = PaperAdventure.asVanilla(entry.key());
        net.minecraft.tags.TagEntry nmsEntry = entry.isTag() ? (entry.isRequired() ? net.minecraft.tags.TagEntry.tag(vanilla) : net.minecraft.tags.TagEntry.optionalTag(vanilla)) : (entry.isRequired() ? net.minecraft.tags.TagEntry.element(vanilla) : net.minecraft.tags.TagEntry.optionalElement(vanilla));
        return new TagLoader.EntryWithSource(nmsEntry, this.owner.getPluginMeta().getDisplayName());
    }

    public boolean hasTag(TagKey<T> tagKey) {
        return this.tags.containsKey(PaperAdventure.asVanilla(tagKey.key()));
    }

    private List<TagLoader.EntryWithSource> getNmsTag(TagKey<T> tagKey, boolean create) {
        Identifier vanillaKey = PaperAdventure.asVanilla(tagKey.key());
        List tag = this.tags.get(vanillaKey);
        if (tag == null) {
            if (create) {
                tag = this.tags.computeIfAbsent(vanillaKey, k -> new ArrayList());
            } else {
                throw new NoSuchElementException("Tag " + String.valueOf(tagKey) + " is not present");
            }
        }
        return tag;
    }

    public List<TagEntry<T>> getTag(TagKey<T> tagKey) {
        return PaperPreFlattenTagRegistrar.convert(this.getNmsTag(tagKey, false));
    }

    public void addToTag(TagKey<T> tagKey, Collection<TagEntry<T>> entries) {
        ArrayList<TagLoader.EntryWithSource> nmsTag = new ArrayList<TagLoader.EntryWithSource>(this.getNmsTag(tagKey, true));
        for (TagEntry<T> tagEntry : entries) {
            nmsTag.add(this.convert(tagEntry));
        }
        this.tags.put(PaperAdventure.asVanilla(tagKey.key()), nmsTag);
    }

    public void setTag(TagKey<T> tagKey, Collection<TagEntry<T>> entries) {
        List newList = List.copyOf(Collections2.transform(entries, this::convert));
        this.tags.put(PaperAdventure.asVanilla(tagKey.key()), newList);
    }
}

