/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.util;

import io.papermc.paper.util.Hashing;
import io.papermc.paper.util.JarManifests;
import java.io.InputStream;
import java.util.Objects;
import java.util.jar.Manifest;
import net.minecraft.world.entity.MobCategory;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;

@DefaultQualifier(value=NonNull.class)
public final class MappingEnvironment {
    public static final boolean DISABLE_PLUGIN_REMAPPING = Boolean.getBoolean("paper.disablePluginRemapping");
    public static final String LEGACY_CB_VERSION = "v1_21_R7";
    private static final @Nullable String MAPPINGS_HASH = MappingEnvironment.readMappingsHash();
    private static final boolean REOBF = MappingEnvironment.checkReobf();

    private MappingEnvironment() {
    }

    public static boolean reobf() {
        return REOBF;
    }

    public static boolean hasMappings() {
        return MAPPINGS_HASH != null;
    }

    public static InputStream mappingsStream() {
        return Objects.requireNonNull(MappingEnvironment.mappingsStreamIfPresent(), "Missing mappings!");
    }

    public static @Nullable InputStream mappingsStreamIfPresent() {
        return MappingEnvironment.class.getClassLoader().getResourceAsStream("META-INF/mappings/reobf.tiny");
    }

    public static String mappingsHash() {
        return Objects.requireNonNull(MAPPINGS_HASH, "MAPPINGS_HASH");
    }

    private static @Nullable String readMappingsHash() {
        String hash;
        @Nullable Manifest manifest = JarManifests.manifest(MappingEnvironment.class);
        if (manifest != null && (hash = manifest.getMainAttributes().getValue("Included-Mappings-Hash")) != null) {
            return hash.toString();
        }
        @Nullable InputStream stream = MappingEnvironment.mappingsStreamIfPresent();
        if (stream == null) {
            return null;
        }
        return Hashing.sha256(stream);
    }

    private static boolean checkReobf() {
        Class<MobCategory> clazz = MobCategory.class;
        if (clazz.getSimpleName().equals("MobCategory")) {
            return false;
        }
        if (clazz.getSimpleName().equals("EnumCreatureType")) {
            return true;
        }
        throw new IllegalStateException();
    }
}

