/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public interface CollectionContentsPredicate<T, P extends Predicate<T>>
extends Predicate<Iterable<T>> {
    public List<P> unpack();

    public static <T, P extends Predicate<T>> Codec<CollectionContentsPredicate<T, P>> codec(Codec<P> testCodec) {
        return testCodec.listOf().xmap(CollectionContentsPredicate::of, CollectionContentsPredicate::unpack);
    }

    @SafeVarargs
    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(P ... tests) {
        return CollectionContentsPredicate.of(List.of(tests));
    }

    public static <T, P extends Predicate<T>> CollectionContentsPredicate<T, P> of(List<P> tests) {
        return switch (tests.size()) {
            case 0 -> new Zero();
            case 1 -> new Single((Predicate)tests.getFirst());
            default -> new Multiple(tests);
        };
    }

    public static class Zero<T, P extends Predicate<T>>
    implements CollectionContentsPredicate<T, P> {
        @Override
        public boolean test(Iterable<T> contents) {
            return true;
        }

        @Override
        public List<P> unpack() {
            return List.of();
        }
    }

    public record Single<T, P extends Predicate<T>>(P test) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> contents) {
            for (T object : contents) {
                if (!this.test.test(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return List.of(this.test);
        }
    }

    public record Multiple<T, P extends Predicate<T>>(List<P> tests) implements CollectionContentsPredicate<T, P>
    {
        @Override
        public boolean test(Iterable<T> contents) {
            ArrayList<P> list = new ArrayList<P>(this.tests);
            for (Object object : contents) {
                list.removeIf(predicate -> predicate.test(object));
                if (!list.isEmpty()) continue;
                return true;
            }
            return false;
        }

        @Override
        public List<P> unpack() {
            return this.tests;
        }
    }
}

