/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.criterion.CollectionContentsPredicate;
import net.minecraft.advancements.criterion.CollectionCountsPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;

public record CollectionPredicate<T, P extends Predicate<T>>(Optional<CollectionContentsPredicate<T, P>> contains, Optional<CollectionCountsPredicate<T, P>> counts, Optional<MinMaxBounds.Ints> size) implements Predicate<Iterable<T>>
{
    public static <T, P extends Predicate<T>> Codec<CollectionPredicate<T, P>> codec(Codec<P> testCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)CollectionContentsPredicate.codec(testCodec).optionalFieldOf("contains").forGetter(CollectionPredicate::contains), (App)CollectionCountsPredicate.codec(testCodec).optionalFieldOf("count").forGetter(CollectionPredicate::counts), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("size").forGetter(CollectionPredicate::size)).apply((Applicative)instance, CollectionPredicate::new));
    }

    @Override
    public boolean test(Iterable<T> collection) {
        return !(this.contains.isPresent() && !this.contains.get().test(collection) || this.counts.isPresent() && !this.counts.get().test(collection) || this.size.isPresent() && !this.size.get().matches(Iterables.size(collection)));
    }
}

