/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.SignedArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.permissions.Permissions;
import org.jspecify.annotations.Nullable;

public class MessageArgument
implements SignedArgument<Message> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Hello world!", "foo", "@e", "Hello @p :)");
    static final Dynamic2CommandExceptionType TOO_LONG = new Dynamic2CommandExceptionType((object, object1) -> Component.translatableEscape("argument.message.too_long", object, object1));

    public static MessageArgument message() {
        return new MessageArgument();
    }

    public static Component getMessage(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Message message = (Message)context.getArgument(name, Message.class);
        return message.resolveComponent((CommandSourceStack)context.getSource());
    }

    public static void resolveChatMessage(CommandContext<CommandSourceStack> context, String key, Consumer<PlayerChatMessage> callback) throws CommandSyntaxException {
        Message message = (Message)context.getArgument(key, Message.class);
        MessageArgument.resolveChatMessage(message, context, key, callback);
    }

    public static void resolveChatMessage(Message message, CommandContext<CommandSourceStack> context, String key, Consumer<PlayerChatMessage> callback) throws CommandSyntaxException {
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Component component = message.resolveComponent(commandSourceStack);
        CommandSigningContext signingContext = commandSourceStack.getSigningContext();
        PlayerChatMessage argument = signingContext.getArgument(key);
        if (argument != null) {
            MessageArgument.resolveSignedMessage(callback, commandSourceStack, argument.withUnsignedContent(component));
        } else {
            MessageArgument.resolveDisguisedMessage(callback, commandSourceStack, PlayerChatMessage.system(message.text).withUnsignedContent(component));
        }
    }

    private static void resolveSignedMessage(Consumer<PlayerChatMessage> callback, CommandSourceStack source, PlayerChatMessage message) {
        MinecraftServer server = source.getServer();
        CompletableFuture<FilteredText> completableFuture = MessageArgument.filterPlainText(source, message);
        CompletableFuture<Component> componentFuture = server.getChatDecorator().decorate(source.getPlayer(), source, message.decoratedContent());
        source.getChatMessageChainer().append(CompletableFuture.allOf(completableFuture, componentFuture), filtered -> {
            PlayerChatMessage playerChatMessage = message.withUnsignedContent((Component)componentFuture.join()).filter(((FilteredText)completableFuture.join()).mask());
            callback.accept(playerChatMessage);
        });
    }

    private static void resolveDisguisedMessage(Consumer<PlayerChatMessage> callback, CommandSourceStack source, PlayerChatMessage message) {
        ChatDecorator chatDecorator = source.getServer().getChatDecorator();
        CompletableFuture<Component> componentFuture = chatDecorator.decorate(source.getPlayer(), source, message.decoratedContent());
        source.getChatMessageChainer().append(componentFuture, result -> callback.accept(message.withUnsignedContent((Component)result)));
    }

    private static CompletableFuture<FilteredText> filterPlainText(CommandSourceStack source, PlayerChatMessage message) {
        ServerPlayer player = source.getPlayer();
        return player != null && message.hasSignatureFrom(player.getUUID()) ? player.getTextFilter().processStreamMessage(message.signedContent()) : CompletableFuture.completedFuture(FilteredText.passThrough(message.signedContent()));
    }

    public Message parse(StringReader reader) throws CommandSyntaxException {
        return Message.parseText(reader, true);
    }

    public <S> Message parse(StringReader stringReader, @Nullable S object) throws CommandSyntaxException {
        return Message.parseText(stringReader, EntitySelectorParser.allowSelectors(object));
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record Message(String text, Part[] parts) {
        Component resolveComponent(CommandSourceStack source) throws CommandSyntaxException {
            return this.toComponent(source, source.permissions().hasPermission(Permissions.COMMANDS_ENTITY_SELECTORS));
        }

        public Component toComponent(CommandSourceStack source, boolean allowSelectors) throws CommandSyntaxException {
            if (this.parts.length != 0 && allowSelectors) {
                MutableComponent mutableComponent = Component.literal(this.text.substring(0, this.parts[0].start()));
                int start = this.parts[0].start();
                for (Part part : this.parts) {
                    Component component = part.toComponent(source);
                    if (start < part.start()) {
                        mutableComponent.append(this.text.substring(start, part.start()));
                    }
                    mutableComponent.append(component);
                    start = part.end();
                }
                if (start < this.text.length()) {
                    mutableComponent.append(this.text.substring(start));
                }
                return mutableComponent;
            }
            return Component.literal(this.text);
        }

        public static Message parseText(StringReader reader, boolean allowSelectors) throws CommandSyntaxException {
            if (reader.getRemainingLength() > 256) {
                throw TOO_LONG.create((Object)reader.getRemainingLength(), (Object)256);
            }
            String remaining = reader.getRemaining();
            if (!allowSelectors) {
                reader.setCursor(reader.getTotalLength());
                return new Message(remaining, new Part[0]);
            }
            ArrayList list = Lists.newArrayList();
            int cursor = reader.getCursor();
            while (true) {
                EntitySelector entitySelector;
                int cursor1;
                block8: {
                    if (!reader.canRead()) {
                        return new Message(remaining, list.toArray(new Part[0]));
                    }
                    if (reader.peek() == '@') {
                        cursor1 = reader.getCursor();
                        try {
                            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(reader, true);
                            entitySelector = entitySelectorParser.parse();
                            break block8;
                        }
                        catch (CommandSyntaxException var8) {
                            if (var8.getType() != EntitySelectorParser.ERROR_MISSING_SELECTOR_TYPE && var8.getType() != EntitySelectorParser.ERROR_UNKNOWN_SELECTOR_TYPE) {
                                throw var8;
                            }
                            reader.setCursor(cursor1 + 1);
                            continue;
                        }
                    }
                    reader.skip();
                    continue;
                }
                list.add(new Part(cursor1 - cursor, reader.getCursor() - cursor, entitySelector));
            }
        }
    }

    public record Part(int start, int end, EntitySelector selector) {
        public Component toComponent(CommandSourceStack source) throws CommandSyntaxException {
            return EntitySelector.joinNames(this.selector.findEntities(source));
        }
    }
}

