/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import java.util.stream.Stream;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import org.jspecify.annotations.Nullable;

public interface DataComponentHolder
extends DataComponentGetter {
    public DataComponentMap getComponents();

    @Override
    default public <T> @Nullable T get(DataComponentType<? extends T> component) {
        return this.getComponents().get(component);
    }

    default public <T> Stream<T> getAllOfType(Class<? extends T> type) {
        return this.getComponents().stream().map(TypedDataComponent::value).filter(object -> type.isAssignableFrom(object.getClass())).map(object -> object);
    }

    @Override
    default public <T> T getOrDefault(DataComponentType<? extends T> component, T defaultValue) {
        return this.getComponents().getOrDefault(component, defaultValue);
    }

    default public boolean has(DataComponentType<?> component) {
        return this.getComponents().has(component);
    }
}

