/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.packs.VanillaAdvancementProvider;
import net.minecraft.data.info.BiomeParametersDumpReport;
import net.minecraft.data.info.BlockListReport;
import net.minecraft.data.info.CommandsReport;
import net.minecraft.data.info.DatapackStructureReport;
import net.minecraft.data.info.ItemListReport;
import net.minecraft.data.info.PacketReport;
import net.minecraft.data.info.RegistryDumpReport;
import net.minecraft.data.loot.packs.TradeRebalanceLootTableProvider;
import net.minecraft.data.loot.packs.VanillaLootTableProvider;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.data.registries.RegistriesDatapackGenerator;
import net.minecraft.data.registries.TradeRebalanceRegistries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.data.structures.SnbtToNbt;
import net.minecraft.data.structures.StructureUpdater;
import net.minecraft.data.tags.BannerPatternTagsProvider;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.data.tags.DialogTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.FlatLevelGeneratorPresetTagsProvider;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.data.tags.GameEventTagsProvider;
import net.minecraft.data.tags.InstrumentTagsProvider;
import net.minecraft.data.tags.PaintingVariantTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.data.tags.TimelineTagsProvider;
import net.minecraft.data.tags.TradeRebalanceEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaBlockTagsProvider;
import net.minecraft.data.tags.VanillaEnchantmentTagsProvider;
import net.minecraft.data.tags.VanillaItemTagsProvider;
import net.minecraft.data.tags.WorldPresetTagsProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.jsonrpc.dataprovider.JsonRpcApiSchema;
import net.minecraft.util.Util;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;

public class Main {
    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] args) throws IOException {
        SharedConstants.tryDetectVersion();
        OptionParser optionParser = new OptionParser();
        AbstractOptionSpec optionSpec = optionParser.accepts("help", "Show the help menu").forHelp();
        OptionSpecBuilder optionSpec1 = optionParser.accepts("server", "Include server generators");
        OptionSpecBuilder optionSpec2 = optionParser.accepts("dev", "Include development tools");
        OptionSpecBuilder optionSpec3 = optionParser.accepts("reports", "Include data reports");
        optionParser.accepts("validate", "Validate inputs");
        OptionSpecBuilder optionSpec4 = optionParser.accepts("all", "Include all generators");
        ArgumentAcceptingOptionSpec optionSpec5 = optionParser.accepts("output", "Output folder").withRequiredArg().defaultsTo((Object)"generated", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionSpec6 = optionParser.accepts("input", "Input folder").withRequiredArg();
        OptionSet optionSet = optionParser.parse(args);
        if (!optionSet.has((OptionSpec)optionSpec) && optionSet.hasOptions()) {
            Path path = Paths.get((String)optionSpec5.value(optionSet), new String[0]);
            boolean hasOptionSpec = optionSet.has((OptionSpec)optionSpec4);
            boolean flag = hasOptionSpec || optionSet.has((OptionSpec)optionSpec1);
            boolean flag1 = hasOptionSpec || optionSet.has((OptionSpec)optionSpec2);
            boolean flag2 = hasOptionSpec || optionSet.has((OptionSpec)optionSpec3);
            List<Path> collection = optionSet.valuesOf((OptionSpec)optionSpec6).stream().map(string -> Paths.get(string, new String[0])).toList();
            DataGenerator dataGenerator = new DataGenerator(path, SharedConstants.getCurrentVersion(), true);
            Main.addServerProviders(dataGenerator, collection, flag, flag1, flag2);
            dataGenerator.run();
            Util.shutdownExecutors();
        } else {
            optionParser.printHelpOn((OutputStream)System.out);
        }
    }

    private static <T extends DataProvider> DataProvider.Factory<T> bindRegistries(BiFunction<PackOutput, CompletableFuture<HolderLookup.Provider>, T> tagProviderFactory, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        return output -> (DataProvider)tagProviderFactory.apply(output, lookupProvider);
    }

    public static void addServerProviders(DataGenerator dataGenerator, Collection<Path> paths, boolean server, boolean dev, boolean reports) {
        DataGenerator.PackGenerator vanillaPack = dataGenerator.getVanillaPack(server);
        vanillaPack.addProvider(output -> new SnbtToNbt(output, paths).addFilter(new StructureUpdater()));
        CompletableFuture<HolderLookup.Provider> completableFuture = CompletableFuture.supplyAsync(VanillaRegistries::createLookup, Util.backgroundExecutor());
        DataGenerator.PackGenerator vanillaPack1 = dataGenerator.getVanillaPack(server);
        vanillaPack1.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(VanillaAdvancementProvider::create, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(VanillaLootTableProvider::create, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(VanillaRecipeProvider.Runner::new, completableFuture));
        TagsProvider tagsProvider = vanillaPack1.addProvider(Main.bindRegistries(VanillaBlockTagsProvider::new, completableFuture));
        TagsProvider tagsProvider1 = vanillaPack1.addProvider(Main.bindRegistries(VanillaItemTagsProvider::new, completableFuture));
        TagsProvider tagsProvider2 = vanillaPack1.addProvider(Main.bindRegistries(BiomeTagsProvider::new, completableFuture));
        TagsProvider tagsProvider3 = vanillaPack1.addProvider(Main.bindRegistries(BannerPatternTagsProvider::new, completableFuture));
        TagsProvider tagsProvider4 = vanillaPack1.addProvider(Main.bindRegistries(StructureTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(DamageTypeTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(DialogTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(EntityTypeTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(FlatLevelGeneratorPresetTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(FluidTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(GameEventTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(InstrumentTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(PaintingVariantTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(PoiTypeTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(WorldPresetTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(VanillaEnchantmentTagsProvider::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(TimelineTagsProvider::new, completableFuture));
        vanillaPack1 = dataGenerator.getVanillaPack(dev);
        vanillaPack1.addProvider(output -> new NbtToSnbt(output, paths));
        vanillaPack1 = dataGenerator.getVanillaPack(reports);
        vanillaPack1.addProvider(Main.bindRegistries(BiomeParametersDumpReport::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(ItemListReport::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(BlockListReport::new, completableFuture));
        vanillaPack1.addProvider(Main.bindRegistries(CommandsReport::new, completableFuture));
        vanillaPack1.addProvider(RegistryDumpReport::new);
        vanillaPack1.addProvider(PacketReport::new);
        vanillaPack1.addProvider(DatapackStructureReport::new);
        vanillaPack1.addProvider(JsonRpcApiSchema::new);
        CompletableFuture<RegistrySetBuilder.PatchedRegistries> completableFuture1 = TradeRebalanceRegistries.createLookup(completableFuture);
        CompletionStage completableFuture2 = completableFuture1.thenApply(RegistrySetBuilder.PatchedRegistries::patches);
        DataGenerator.PackGenerator builtinDatapack = dataGenerator.getBuiltinDatapack(server, "trade_rebalance");
        builtinDatapack.addProvider(Main.bindRegistries(RegistriesDatapackGenerator::new, (CompletableFuture<HolderLookup.Provider>)completableFuture2));
        builtinDatapack.addProvider(output -> PackMetadataGenerator.forFeaturePack(output, Component.translatable("dataPack.trade_rebalance.description"), FeatureFlagSet.of(FeatureFlags.TRADE_REBALANCE)));
        builtinDatapack.addProvider(Main.bindRegistries(TradeRebalanceLootTableProvider::create, completableFuture));
        builtinDatapack.addProvider(Main.bindRegistries(TradeRebalanceEnchantmentTagsProvider::new, completableFuture));
        vanillaPack1 = dataGenerator.getBuiltinDatapack(server, "redstone_experiments");
        vanillaPack1.addProvider(output -> PackMetadataGenerator.forFeaturePack(output, Component.translatable("dataPack.redstone_experiments.description"), FeatureFlagSet.of(FeatureFlags.REDSTONE_EXPERIMENTS)));
        vanillaPack1 = dataGenerator.getBuiltinDatapack(server, "minecart_improvements");
        vanillaPack1.addProvider(output -> PackMetadataGenerator.forFeaturePack(output, Component.translatable("dataPack.minecart_improvements.description"), FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS)));
    }
}

