/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.info;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTypes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockListReport
implements DataProvider {
    private final PackOutput output;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public BlockListReport(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = output;
        this.registries = registries;
    }

    @Override
    public CompletableFuture<?> run(CachedOutput output) {
        Path path = this.output.getOutputFolder(PackOutput.Target.REPORTS).resolve("blocks.json");
        return this.registries.thenCompose(provider -> {
            JsonObject jsonObject = new JsonObject();
            RegistryOps registryOps = provider.createSerializationContext(JsonOps.INSTANCE);
            provider.lookupOrThrow(Registries.BLOCK).listElements().forEach(reference -> {
                JsonObject jsonObject1 = new JsonObject();
                StateDefinition<Block, BlockState> stateDefinition = ((Block)reference.value()).getStateDefinition();
                if (!stateDefinition.getProperties().isEmpty()) {
                    JsonObject jsonObject2 = new JsonObject();
                    for (Property property : stateDefinition.getProperties()) {
                        JsonArray jsonArray = new JsonArray();
                        for (Comparable comparable : property.getPossibleValues()) {
                            jsonArray.add(Util.getPropertyName(property, comparable));
                        }
                        jsonObject2.add(property.getName(), (JsonElement)jsonArray);
                    }
                    jsonObject1.add("properties", (JsonElement)jsonObject2);
                }
                JsonArray jsonArray1 = new JsonArray();
                for (BlockState blockState : stateDefinition.getPossibleStates()) {
                    JsonObject jsonObject3 = new JsonObject();
                    JsonObject jsonObject4 = new JsonObject();
                    for (Property<?> property1 : stateDefinition.getProperties()) {
                        jsonObject4.addProperty(property1.getName(), Util.getPropertyName(property1, blockState.getValue(property1)));
                    }
                    if (!jsonObject4.isEmpty()) {
                        jsonObject3.add("properties", (JsonElement)jsonObject4);
                    }
                    jsonObject3.addProperty("id", (Number)Block.getId(blockState));
                    if (blockState == ((Block)reference.value()).defaultBlockState()) {
                        jsonObject3.addProperty("default", Boolean.valueOf(true));
                    }
                    jsonArray1.add((JsonElement)jsonObject3);
                }
                jsonObject1.add("states", (JsonElement)jsonArray1);
                String registeredName = reference.getRegisteredName();
                JsonElement jsonElement = (JsonElement)BlockTypes.CODEC.codec().encodeStart((DynamicOps)registryOps, (Object)((Block)reference.value())).getOrThrow(string -> new AssertionError((Object)("Failed to serialize block " + registeredName + " (is type registered in BlockTypes?): " + string)));
                jsonObject1.add("definition", jsonElement);
                jsonObject.add(registeredName, (JsonElement)jsonObject1);
            });
            return DataProvider.saveStable(output, (JsonElement)jsonObject, path);
        });
    }

    @Override
    public final String getName() {
        return "Block List";
    }
}

