/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen.placement;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class TreePlacements {
    public static final ResourceKey<PlacedFeature> CRIMSON_FUNGI = PlacementUtils.createKey("crimson_fungi");
    public static final ResourceKey<PlacedFeature> WARPED_FUNGI = PlacementUtils.createKey("warped_fungi");
    public static final ResourceKey<PlacedFeature> OAK_CHECKED = PlacementUtils.createKey("oak_checked");
    public static final ResourceKey<PlacedFeature> DARK_OAK_CHECKED = PlacementUtils.createKey("dark_oak_checked");
    public static final ResourceKey<PlacedFeature> PALE_OAK_CHECKED = PlacementUtils.createKey("pale_oak_checked");
    public static final ResourceKey<PlacedFeature> PALE_OAK_CREAKING_CHECKED = PlacementUtils.createKey("pale_oak_creaking_checked");
    public static final ResourceKey<PlacedFeature> BIRCH_CHECKED = PlacementUtils.createKey("birch_checked");
    public static final ResourceKey<PlacedFeature> ACACIA_CHECKED = PlacementUtils.createKey("acacia_checked");
    public static final ResourceKey<PlacedFeature> SPRUCE_CHECKED = PlacementUtils.createKey("spruce_checked");
    public static final ResourceKey<PlacedFeature> MANGROVE_CHECKED = PlacementUtils.createKey("mangrove_checked");
    public static final ResourceKey<PlacedFeature> CHERRY_CHECKED = PlacementUtils.createKey("cherry_checked");
    public static final ResourceKey<PlacedFeature> PINE_ON_SNOW = PlacementUtils.createKey("pine_on_snow");
    public static final ResourceKey<PlacedFeature> SPRUCE_ON_SNOW = PlacementUtils.createKey("spruce_on_snow");
    public static final ResourceKey<PlacedFeature> PINE_CHECKED = PlacementUtils.createKey("pine_checked");
    public static final ResourceKey<PlacedFeature> JUNGLE_TREE_CHECKED = PlacementUtils.createKey("jungle_tree");
    public static final ResourceKey<PlacedFeature> FANCY_OAK_CHECKED = PlacementUtils.createKey("fancy_oak_checked");
    public static final ResourceKey<PlacedFeature> MEGA_JUNGLE_TREE_CHECKED = PlacementUtils.createKey("mega_jungle_tree_checked");
    public static final ResourceKey<PlacedFeature> MEGA_SPRUCE_CHECKED = PlacementUtils.createKey("mega_spruce_checked");
    public static final ResourceKey<PlacedFeature> MEGA_PINE_CHECKED = PlacementUtils.createKey("mega_pine_checked");
    public static final ResourceKey<PlacedFeature> TALL_MANGROVE_CHECKED = PlacementUtils.createKey("tall_mangrove_checked");
    public static final ResourceKey<PlacedFeature> JUNGLE_BUSH = PlacementUtils.createKey("jungle_bush");
    public static final ResourceKey<PlacedFeature> SUPER_BIRCH_BEES_0002 = PlacementUtils.createKey("super_birch_bees_0002");
    public static final ResourceKey<PlacedFeature> SUPER_BIRCH_BEES = PlacementUtils.createKey("super_birch_bees");
    public static final ResourceKey<PlacedFeature> OAK_BEES_0002_LEAF_LITTER = PlacementUtils.createKey("oak_bees_0002_leaf_litter");
    public static final ResourceKey<PlacedFeature> OAK_BEES_002 = PlacementUtils.createKey("oak_bees_002");
    public static final ResourceKey<PlacedFeature> BIRCH_BEES_0002_PLACED = PlacementUtils.createKey("birch_bees_0002");
    public static final ResourceKey<PlacedFeature> BIRCH_BEES_0002_LEAF_LITTER = PlacementUtils.createKey("birch_bees_0002_leaf_litter");
    public static final ResourceKey<PlacedFeature> BIRCH_BEES_002 = PlacementUtils.createKey("birch_bees_002");
    public static final ResourceKey<PlacedFeature> FANCY_OAK_BEES_0002_LEAF_LITTER = PlacementUtils.createKey("fancy_oak_bees_0002_leaf_litter");
    public static final ResourceKey<PlacedFeature> FANCY_OAK_BEES_002 = PlacementUtils.createKey("fancy_oak_bees_002");
    public static final ResourceKey<PlacedFeature> FANCY_OAK_BEES = PlacementUtils.createKey("fancy_oak_bees");
    public static final ResourceKey<PlacedFeature> CHERRY_BEES_005 = PlacementUtils.createKey("cherry_bees_005");
    public static final ResourceKey<PlacedFeature> OAK_LEAF_LITTER = PlacementUtils.createKey("oak_leaf_litter");
    public static final ResourceKey<PlacedFeature> DARK_OAK_LEAF_LITTER = PlacementUtils.createKey("dark_oak_leaf_litter");
    public static final ResourceKey<PlacedFeature> BIRCH_LEAF_LITTER = PlacementUtils.createKey("birch_leaf_litter");
    public static final ResourceKey<PlacedFeature> FANCY_OAK_LEAF_LITTER = PlacementUtils.createKey("fancy_oak_leaf_litter");
    public static final ResourceKey<PlacedFeature> FALLEN_OAK_TREE = PlacementUtils.createKey("fallen_oak_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_BIRCH_TREE = PlacementUtils.createKey("fallen_birch_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_SUPER_BIRCH_TREE = PlacementUtils.createKey("fallen_super_birch_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_SPRUCE_TREE = PlacementUtils.createKey("fallen_spruce_tree");
    public static final ResourceKey<PlacedFeature> FALLEN_JUNGLE_TREE = PlacementUtils.createKey("fallen_jungle_tree");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter<ConfiguredFeature<?, ?>> holderGetter = context.lookup(Registries.CONFIGURED_FEATURE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow = holderGetter.getOrThrow(TreeFeatures.CRIMSON_FUNGUS);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow1 = holderGetter.getOrThrow(TreeFeatures.WARPED_FUNGUS);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow2 = holderGetter.getOrThrow(TreeFeatures.OAK);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow3 = holderGetter.getOrThrow(TreeFeatures.DARK_OAK);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow4 = holderGetter.getOrThrow(TreeFeatures.PALE_OAK);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow5 = holderGetter.getOrThrow(TreeFeatures.PALE_OAK_CREAKING);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow6 = holderGetter.getOrThrow(TreeFeatures.BIRCH);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow7 = holderGetter.getOrThrow(TreeFeatures.ACACIA);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow8 = holderGetter.getOrThrow(TreeFeatures.SPRUCE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow9 = holderGetter.getOrThrow(TreeFeatures.MANGROVE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow10 = holderGetter.getOrThrow(TreeFeatures.CHERRY);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow11 = holderGetter.getOrThrow(TreeFeatures.PINE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow12 = holderGetter.getOrThrow(TreeFeatures.JUNGLE_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow13 = holderGetter.getOrThrow(TreeFeatures.FANCY_OAK);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow14 = holderGetter.getOrThrow(TreeFeatures.MEGA_JUNGLE_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow15 = holderGetter.getOrThrow(TreeFeatures.MEGA_SPRUCE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow16 = holderGetter.getOrThrow(TreeFeatures.MEGA_PINE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow17 = holderGetter.getOrThrow(TreeFeatures.TALL_MANGROVE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow18 = holderGetter.getOrThrow(TreeFeatures.JUNGLE_BUSH);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow19 = holderGetter.getOrThrow(TreeFeatures.SUPER_BIRCH_BEES_0002);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow20 = holderGetter.getOrThrow(TreeFeatures.SUPER_BIRCH_BEES);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow21 = holderGetter.getOrThrow(TreeFeatures.OAK_BEES_0002_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow22 = holderGetter.getOrThrow(TreeFeatures.OAK_BEES_002);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow23 = holderGetter.getOrThrow(TreeFeatures.BIRCH_BEES_0002);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow24 = holderGetter.getOrThrow(TreeFeatures.BIRCH_BEES_0002_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow25 = holderGetter.getOrThrow(TreeFeatures.BIRCH_BEES_002);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow26 = holderGetter.getOrThrow(TreeFeatures.FANCY_OAK_BEES_0002_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow27 = holderGetter.getOrThrow(TreeFeatures.FANCY_OAK_BEES_002);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow28 = holderGetter.getOrThrow(TreeFeatures.FANCY_OAK_BEES);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow29 = holderGetter.getOrThrow(TreeFeatures.CHERRY_BEES_005);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow30 = holderGetter.getOrThrow(TreeFeatures.OAK_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow31 = holderGetter.getOrThrow(TreeFeatures.DARK_OAK_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow32 = holderGetter.getOrThrow(TreeFeatures.BIRCH_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow33 = holderGetter.getOrThrow(TreeFeatures.FANCY_OAK_LEAF_LITTER);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow34 = holderGetter.getOrThrow(TreeFeatures.FALLEN_OAK_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow35 = holderGetter.getOrThrow(TreeFeatures.FALLEN_BIRCH_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow36 = holderGetter.getOrThrow(TreeFeatures.FALLEN_SUPER_BIRCH_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow37 = holderGetter.getOrThrow(TreeFeatures.FALLEN_SPRUCE_TREE);
        Holder.Reference<ConfiguredFeature<?, ?>> orThrow38 = holderGetter.getOrThrow(TreeFeatures.FALLEN_JUNGLE_TREE);
        PlacementUtils.register(context, CRIMSON_FUNGI, orThrow, CountOnEveryLayerPlacement.of(8), BiomeFilter.biome());
        PlacementUtils.register(context, WARPED_FUNGI, orThrow1, CountOnEveryLayerPlacement.of(8), BiomeFilter.biome());
        PlacementUtils.register(context, OAK_CHECKED, orThrow2, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, DARK_OAK_CHECKED, orThrow3, PlacementUtils.filteredByBlockSurvival(Blocks.DARK_OAK_SAPLING));
        PlacementUtils.register(context, PALE_OAK_CHECKED, orThrow4, PlacementUtils.filteredByBlockSurvival(Blocks.PALE_OAK_SAPLING));
        PlacementUtils.register(context, PALE_OAK_CREAKING_CHECKED, orThrow5, PlacementUtils.filteredByBlockSurvival(Blocks.PALE_OAK_SAPLING));
        PlacementUtils.register(context, BIRCH_CHECKED, orThrow6, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, ACACIA_CHECKED, orThrow7, PlacementUtils.filteredByBlockSurvival(Blocks.ACACIA_SAPLING));
        PlacementUtils.register(context, SPRUCE_CHECKED, orThrow8, PlacementUtils.filteredByBlockSurvival(Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(context, MANGROVE_CHECKED, orThrow9, PlacementUtils.filteredByBlockSurvival(Blocks.MANGROVE_PROPAGULE));
        PlacementUtils.register(context, CHERRY_CHECKED, orThrow10, PlacementUtils.filteredByBlockSurvival(Blocks.CHERRY_SAPLING));
        BlockPredicate blockPredicate = BlockPredicate.matchesBlocks(Direction.DOWN.getUnitVec3i(), Blocks.SNOW_BLOCK, Blocks.POWDER_SNOW);
        List<PlacementModifier> list = List.of(EnvironmentScanPlacement.scanningFor(Direction.UP, BlockPredicate.not(BlockPredicate.matchesBlocks(Blocks.POWDER_SNOW)), 8), BlockPredicateFilter.forPredicate(blockPredicate));
        PlacementUtils.register(context, PINE_ON_SNOW, orThrow11, list);
        PlacementUtils.register(context, SPRUCE_ON_SNOW, orThrow8, list);
        PlacementUtils.register(context, PINE_CHECKED, orThrow11, PlacementUtils.filteredByBlockSurvival(Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(context, JUNGLE_TREE_CHECKED, orThrow12, PlacementUtils.filteredByBlockSurvival(Blocks.JUNGLE_SAPLING));
        PlacementUtils.register(context, FANCY_OAK_CHECKED, orThrow13, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, MEGA_JUNGLE_TREE_CHECKED, orThrow14, PlacementUtils.filteredByBlockSurvival(Blocks.JUNGLE_SAPLING));
        PlacementUtils.register(context, MEGA_SPRUCE_CHECKED, orThrow15, PlacementUtils.filteredByBlockSurvival(Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(context, MEGA_PINE_CHECKED, orThrow16, PlacementUtils.filteredByBlockSurvival(Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(context, TALL_MANGROVE_CHECKED, orThrow17, PlacementUtils.filteredByBlockSurvival(Blocks.MANGROVE_PROPAGULE));
        PlacementUtils.register(context, JUNGLE_BUSH, orThrow18, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, SUPER_BIRCH_BEES_0002, orThrow19, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, SUPER_BIRCH_BEES, orThrow20, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, OAK_BEES_0002_LEAF_LITTER, orThrow21, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, OAK_BEES_002, orThrow22, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, BIRCH_BEES_0002_PLACED, orThrow23, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, BIRCH_BEES_0002_LEAF_LITTER, orThrow24, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, BIRCH_BEES_002, orThrow25, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, FANCY_OAK_BEES_0002_LEAF_LITTER, orThrow26, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, FANCY_OAK_BEES_002, orThrow27, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, FANCY_OAK_BEES, orThrow28, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, CHERRY_BEES_005, orThrow29, PlacementUtils.filteredByBlockSurvival(Blocks.CHERRY_SAPLING));
        PlacementUtils.register(context, OAK_LEAF_LITTER, orThrow30, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, DARK_OAK_LEAF_LITTER, orThrow31, PlacementUtils.filteredByBlockSurvival(Blocks.DARK_OAK_SAPLING));
        PlacementUtils.register(context, BIRCH_LEAF_LITTER, orThrow32, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, FANCY_OAK_LEAF_LITTER, orThrow33, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, FALLEN_OAK_TREE, orThrow34, PlacementUtils.filteredByBlockSurvival(Blocks.OAK_SAPLING));
        PlacementUtils.register(context, FALLEN_BIRCH_TREE, orThrow35, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, FALLEN_SUPER_BIRCH_TREE, orThrow36, PlacementUtils.filteredByBlockSurvival(Blocks.BIRCH_SAPLING));
        PlacementUtils.register(context, FALLEN_SPRUCE_TREE, orThrow37, PlacementUtils.filteredByBlockSurvival(Blocks.SPRUCE_SAPLING));
        PlacementUtils.register(context, FALLEN_JUNGLE_TREE, orThrow38, PlacementUtils.filteredByBlockSurvival(Blocks.JUNGLE_SAPLING));
    }
}

