/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.FailedTestTracker;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestInstanceFinder;
import net.minecraft.gametest.framework.TestPosFinder;

public class TestFinder
implements TestInstanceFinder,
TestPosFinder {
    static final TestInstanceFinder NO_FUNCTIONS = Stream::empty;
    static final TestPosFinder NO_STRUCTURES = Stream::empty;
    private final TestInstanceFinder testInstanceFinder;
    private final TestPosFinder testPosFinder;
    private final CommandSourceStack source;

    @Override
    public Stream<BlockPos> findTestPos() {
        return this.testPosFinder.findTestPos();
    }

    public static Builder builder() {
        return new Builder();
    }

    TestFinder(CommandSourceStack source, TestInstanceFinder testInstanceFinder, TestPosFinder testPosFinder) {
        this.source = source;
        this.testInstanceFinder = testInstanceFinder;
        this.testPosFinder = testPosFinder;
    }

    public CommandSourceStack source() {
        return this.source;
    }

    @Override
    public Stream<Holder.Reference<GameTestInstance>> findTests() {
        return this.testInstanceFinder.findTests();
    }

    public static class Builder {
        private final UnaryOperator<Supplier<Stream<Holder.Reference<GameTestInstance>>>> testFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPos>>> structureBlockPosFinderWrapper;

        public Builder() {
            this.testFinderWrapper = supplier -> supplier;
            this.structureBlockPosFinderWrapper = supplier -> supplier;
        }

        private Builder(UnaryOperator<Supplier<Stream<Holder.Reference<GameTestInstance>>>> testFinderWrapper, UnaryOperator<Supplier<Stream<BlockPos>>> structureBlockPosFinderWrapper) {
            this.testFinderWrapper = testFinderWrapper;
            this.structureBlockPosFinderWrapper = structureBlockPosFinderWrapper;
        }

        public Builder createMultipleCopies(int count) {
            return new Builder(Builder.createCopies(count), Builder.createCopies(count));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int count) {
            return supplier -> {
                LinkedList list = new LinkedList();
                List list1 = ((Stream)supplier.get()).toList();
                for (int i = 0; i < count; ++i) {
                    list.addAll(list1);
                }
                return list::stream;
            };
        }

        private TestFinder build(CommandSourceStack source, TestInstanceFinder instanceFinder, TestPosFinder posFinder) {
            return new TestFinder(source, ((Supplier)((Supplier)this.testFinderWrapper.apply(instanceFinder::findTests)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply(posFinder::findTestPos)))::get);
        }

        public TestFinder radius(CommandContext<CommandSourceStack> context, int radius) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            BlockPos blockPos = BlockPos.containing(commandSourceStack.getPosition());
            return this.build(commandSourceStack, NO_FUNCTIONS, () -> StructureUtils.findTestBlocks(blockPos, radius, commandSourceStack.getLevel()));
        }

        public TestFinder nearest(CommandContext<CommandSourceStack> context) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            BlockPos blockPos = BlockPos.containing(commandSourceStack.getPosition());
            return this.build(commandSourceStack, NO_FUNCTIONS, () -> StructureUtils.findNearestTest(blockPos, 15, commandSourceStack.getLevel()).stream());
        }

        public TestFinder allNearby(CommandContext<CommandSourceStack> context) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            BlockPos blockPos = BlockPos.containing(commandSourceStack.getPosition());
            return this.build(commandSourceStack, NO_FUNCTIONS, () -> StructureUtils.findTestBlocks(blockPos, 250, commandSourceStack.getLevel()));
        }

        public TestFinder lookedAt(CommandContext<CommandSourceStack> context) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
            return this.build(commandSourceStack, NO_FUNCTIONS, () -> StructureUtils.lookedAtTestPos(BlockPos.containing(commandSourceStack.getPosition()), commandSourceStack.getPlayer().getCamera(), commandSourceStack.getLevel()));
        }

        public TestFinder failedTests(CommandContext<CommandSourceStack> context, boolean onlyRequired) {
            return this.build((CommandSourceStack)context.getSource(), () -> FailedTestTracker.getLastFailedTests().filter(reference -> !onlyRequired || ((GameTestInstance)reference.value()).required()), NO_STRUCTURES);
        }

        public TestFinder byResourceSelection(CommandContext<CommandSourceStack> context, Collection<Holder.Reference<GameTestInstance>> collection) {
            return this.build((CommandSourceStack)context.getSource(), collection::stream, NO_STRUCTURES);
        }

        public TestFinder failedTests(CommandContext<CommandSourceStack> context) {
            return this.failedTests(context, false);
        }
    }
}

