/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gizmos;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.gizmos.Gizmo;
import net.minecraft.gizmos.GizmoCollector;
import net.minecraft.gizmos.GizmoProperties;
import net.minecraft.util.Mth;
import net.minecraft.util.Util;

public class SimpleGizmoCollector
implements GizmoCollector {
    private final List<GizmoInstance> gizmos = new ArrayList<GizmoInstance>();
    private final List<GizmoInstance> temporaryGizmos = new ArrayList<GizmoInstance>();

    @Override
    public GizmoProperties add(Gizmo gizmo) {
        GizmoInstance gizmoInstance = new GizmoInstance(gizmo);
        this.gizmos.add(gizmoInstance);
        return gizmoInstance;
    }

    public List<GizmoInstance> drainGizmos() {
        ArrayList<GizmoInstance> list = new ArrayList<GizmoInstance>(this.gizmos);
        list.addAll(this.temporaryGizmos);
        long millis = Util.getMillis();
        this.gizmos.removeIf(gizmoInstance -> gizmoInstance.getExpireTimeMillis() < millis);
        this.temporaryGizmos.clear();
        return list;
    }

    public List<GizmoInstance> getGizmos() {
        return this.gizmos;
    }

    public void addTemporaryGizmos(Collection<GizmoInstance> gizmos) {
        this.temporaryGizmos.addAll(gizmos);
    }

    public static class GizmoInstance
    implements GizmoProperties {
        private final Gizmo gizmo;
        private boolean isAlwaysOnTop;
        private long startTimeMillis;
        private long expireTimeMillis;
        private boolean shouldFadeOut;

        GizmoInstance(Gizmo gizmo) {
            this.gizmo = gizmo;
        }

        @Override
        public GizmoProperties setAlwaysOnTop() {
            this.isAlwaysOnTop = true;
            return this;
        }

        @Override
        public GizmoProperties persistForMillis(int time) {
            this.startTimeMillis = Util.getMillis();
            this.expireTimeMillis = this.startTimeMillis + (long)time;
            return this;
        }

        @Override
        public GizmoProperties fadeOut() {
            this.shouldFadeOut = true;
            return this;
        }

        public float getAlphaMultiplier(long timeMillis) {
            if (this.shouldFadeOut) {
                long l = this.expireTimeMillis - this.startTimeMillis;
                long l1 = timeMillis - this.startTimeMillis;
                return 1.0f - Mth.clamp((float)l1 / (float)l, 0.0f, 1.0f);
            }
            return 1.0f;
        }

        public boolean isAlwaysOnTop() {
            return this.isAlwaysOnTop;
        }

        public long getExpireTimeMillis() {
            return this.expireTimeMillis;
        }

        public Gizmo gizmo() {
            return this.gizmo;
        }
    }
}

