/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ObjectContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ComponentSerialization {
    public static final Codec<Component> CODEC = Codec.recursive((String)"Component", ComponentSerialization::createCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> STREAM_CODEC = ComponentSerialization.createTranslationAware(NbtAccounter::defaultQuota);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> OPTIONAL_STREAM_CODEC = STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final ThreadLocal<Boolean> DONT_RENDER_TRANSLATABLES = ThreadLocal.withInitial(() -> false);
    public static final StreamCodec<RegistryFriendlyByteBuf, Component> TRUSTED_STREAM_CODEC = ComponentSerialization.createTranslationAware(NbtAccounter::unlimitedHeap);
    public static final StreamCodec<RegistryFriendlyByteBuf, Optional<Component>> TRUSTED_OPTIONAL_STREAM_CODEC = TRUSTED_STREAM_CODEC.apply(ByteBufCodecs::optional);
    public static final StreamCodec<ByteBuf, Component> TRUSTED_CONTEXT_FREE_STREAM_CODEC = ByteBufCodecs.fromCodecTrusted(CODEC);
    private static final Map<Locale, Codec<Component>> LOCALIZED_CODECS = new ConcurrentHashMap<Locale, Codec<Component>>();

    private static StreamCodec<RegistryFriendlyByteBuf, Component> createTranslationAware(final Supplier<NbtAccounter> sizeTracker) {
        return new StreamCodec<RegistryFriendlyByteBuf, Component>(){
            final StreamCodec<ByteBuf, Tag> streamCodec;
            {
                this.streamCodec = ByteBufCodecs.tagCodec(sizeTracker);
            }

            @Override
            public Component decode(RegistryFriendlyByteBuf registryFriendlyByteBuf) {
                Tag tag = (Tag)this.streamCodec.decode(registryFriendlyByteBuf);
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                return (Component)CODEC.parse(registryOps, (Object)tag).getOrThrow(error -> new DecoderException("Failed to decode: " + error + " " + String.valueOf(tag)));
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryFriendlyByteBuf, Component object) {
                RegistryOps<Tag> registryOps = registryFriendlyByteBuf.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Tag tag = (Tag)(DONT_RENDER_TRANSLATABLES.get() != false ? CODEC : ComponentSerialization.localizedCodec(registryFriendlyByteBuf.adventure$locale)).encodeStart(registryOps, (Object)object).getOrThrow(error -> new EncoderException("Failed to encode: " + error + " " + String.valueOf(object)));
                this.streamCodec.encode(registryFriendlyByteBuf, tag);
            }
        };
    }

    public static Codec<Component> flatRestrictedCodec(final int maxSize) {
        return new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> ops, T input) {
                return CODEC.decode(ops, input).flatMap(pair -> this.isTooLarge(ops, (Component)pair.getFirst()) ? DataResult.error(() -> "Component was too large: greater than max size " + maxSize) : DataResult.success((Object)pair));
            }

            public <T> DataResult<T> encode(Component input, DynamicOps<T> ops, T value) {
                return CODEC.encodeStart(ops, (Object)input);
            }

            private <T> boolean isTooLarge(DynamicOps<T> ops, Component component) {
                DataResult dataResult = CODEC.encodeStart(2.asJsonOps(ops), (Object)component);
                return dataResult.isSuccess() && GsonHelper.encodesLongerThan((JsonElement)dataResult.getOrThrow(), maxSize);
            }

            private static <T> DynamicOps<JsonElement> asJsonOps(DynamicOps<T> ops) {
                Object object;
                if (ops instanceof RegistryOps) {
                    RegistryOps registryOps = (RegistryOps)ops;
                    object = registryOps.withParent(JsonOps.INSTANCE);
                } else {
                    object = JsonOps.INSTANCE;
                }
                return object;
            }
        };
    }

    private static MutableComponent createFromList(List<Component> components) {
        MutableComponent mutableComponent = components.get(0).copy();
        for (int i = 1; i < components.size(); ++i) {
            mutableComponent.append(components.get(i));
        }
        return mutableComponent;
    }

    public static <T> MapCodec<T> createLegacyComponentMatcher(ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends T>> idMapper, Function<T, MapCodec<? extends T>> codecGetter, String typeFieldName) {
        FuzzyCodec<? extends T> mapCodec = new FuzzyCodec<T>(idMapper.values(), codecGetter);
        MapCodec mapCodec1 = idMapper.codec((Codec<String>)Codec.STRING).dispatchMap(typeFieldName, codecGetter, mapCodec3 -> mapCodec3);
        StrictEither<? extends T> mapCodec2 = new StrictEither<T>(typeFieldName, mapCodec1, mapCodec);
        return ExtraCodecs.orCompressed(mapCodec2, mapCodec1);
    }

    public static Codec<Component> localizedCodec(@Nullable Locale locale) {
        if (locale == null) {
            return CODEC;
        }
        return LOCALIZED_CODECS.computeIfAbsent(locale, loc -> Codec.recursive((String)"Component", selfCodec -> ComponentSerialization.createCodec((Codec<Component>)selfCodec, loc)));
    }

    private static Codec<Component> createCodec(Codec<Component> codec) {
        return ComponentSerialization.createCodec(codec, null);
    }

    private static Codec<Component> createCodec(Codec<Component> codec, final @javax.annotation.Nullable Locale locale) {
        Codec codec1;
        ExtraCodecs.LateBoundIdMapper lateBoundIdMapper = new ExtraCodecs.LateBoundIdMapper();
        ComponentSerialization.bootstrap(lateBoundIdMapper);
        MapCodec<ComponentContents> mapCodec = ComponentSerialization.createLegacyComponentMatcher(lateBoundIdMapper, ComponentContents::codec, "type");
        final Codec origCodec = codec1 = RecordCodecBuilder.create(instance -> instance.group((App)mapCodec.forGetter(Component::getContents), (App)ExtraCodecs.nonEmptyList(codec.listOf()).optionalFieldOf("extra", List.of()).forGetter(Component::getSiblings), (App)Style.Serializer.MAP_CODEC.forGetter(Component::getStyle)).apply((Applicative)instance, MutableComponent::new));
        codec1 = new Codec<Component>(){

            public <T> DataResult<Pair<Component, T>> decode(DynamicOps<T> ops, T input) {
                return origCodec.decode(ops, input);
            }

            public <T> DataResult<T> encode(Component input, DynamicOps<T> ops, T prefix) {
                net.kyori.adventure.text.Component adventureComponent;
                if (input instanceof AdventureComponent) {
                    AdventureComponent adv = (AdventureComponent)input;
                    adventureComponent = adv.adventure$component();
                } else if (locale != null && input.getContents() instanceof TranslatableContents && PaperAdventure.hasAnyTranslations()) {
                    adventureComponent = PaperAdventure.asAdventure(input);
                } else {
                    return origCodec.encode((Object)input, ops, prefix);
                }
                return PaperAdventure.localizedCodec(locale).encode((Object)adventureComponent, ops, prefix);
            }

            public String toString() {
                return origCodec.toString() + "[AdventureComponentAware]";
            }
        };
        return Codec.either((Codec)Codec.either((Codec)Codec.STRING, ExtraCodecs.nonEmptyList(codec.listOf())), (Codec)codec1).xmap(either -> either.map(either1 -> either1.map(Component::literal, ComponentSerialization::createFromList), component -> component), component -> {
            String string = component.tryCollapseToString();
            return string != null ? Either.left(Either.left(string)) : Either.right(component);
        });
    }

    private static void bootstrap(ExtraCodecs.LateBoundIdMapper<String, MapCodec<? extends ComponentContents>> idMapper) {
        idMapper.put("text", PlainTextContents.MAP_CODEC);
        idMapper.put("translatable", TranslatableContents.MAP_CODEC);
        idMapper.put("keybind", KeybindContents.MAP_CODEC);
        idMapper.put("score", ScoreContents.MAP_CODEC);
        idMapper.put("selector", SelectorContents.MAP_CODEC);
        idMapper.put("nbt", NbtContents.MAP_CODEC);
        idMapper.put("object", ObjectContents.MAP_CODEC);
    }

    static class FuzzyCodec<T>
    extends MapCodec<T> {
        private final Collection<MapCodec<? extends T>> codecs;
        private final Function<T, ? extends MapEncoder<? extends T>> encoderGetter;

        public FuzzyCodec(Collection<MapCodec<? extends T>> codecs, Function<T, ? extends MapEncoder<? extends T>> encoderGetter) {
            this.codecs = codecs;
            this.encoderGetter = encoderGetter;
        }

        public <S> DataResult<T> decode(DynamicOps<S> ops, MapLike<S> input) {
            for (MapDecoder mapDecoder : this.codecs) {
                DataResult dataResult = mapDecoder.decode(ops, input);
                if (!dataResult.result().isPresent()) continue;
                return dataResult;
            }
            return DataResult.error(() -> "No matching codec found");
        }

        public <S> RecordBuilder<S> encode(T input, DynamicOps<S> ops, RecordBuilder<S> prefix) {
            MapEncoder<? extends T> mapEncoder = this.encoderGetter.apply(input);
            return mapEncoder.encode(input, ops, prefix);
        }

        public <S> Stream<S> keys(DynamicOps<S> ops) {
            return this.codecs.stream().flatMap(mapCodec -> mapCodec.keys(ops)).distinct();
        }

        public String toString() {
            return "FuzzyCodec[" + String.valueOf(this.codecs) + "]";
        }
    }

    static class StrictEither<T>
    extends MapCodec<T> {
        private final String typeFieldName;
        private final MapCodec<T> typed;
        private final MapCodec<T> fuzzy;

        public StrictEither(String typeFieldName, MapCodec<T> typed, MapCodec<T> fuzzy) {
            this.typeFieldName = typeFieldName;
            this.typed = typed;
            this.fuzzy = fuzzy;
        }

        public <O> DataResult<T> decode(DynamicOps<O> ops, MapLike<O> input) {
            return input.get(this.typeFieldName) != null ? this.typed.decode(ops, input) : this.fuzzy.decode(ops, input);
        }

        public <O> RecordBuilder<O> encode(T input, DynamicOps<O> ops, RecordBuilder<O> prefix) {
            return this.fuzzy.encode(input, ops, prefix);
        }

        public <T1> Stream<T1> keys(DynamicOps<T1> ops) {
            return Stream.concat(this.typed.keys(ops), this.fuzzy.keys(ops)).distinct();
        }
    }
}

