/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import io.papermc.paper.adventure.AdventureComponent;
import io.papermc.paper.annotation.DoNotUse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;

public class ComponentUtils {
    public static final String DEFAULT_SEPARATOR_TEXT = ", ";
    public static final Component DEFAULT_SEPARATOR = Component.literal(", ").withStyle(ChatFormatting.GRAY);
    public static final Component DEFAULT_NO_STYLE_SEPARATOR = Component.literal(", ");

    @CheckReturnValue
    public static MutableComponent mergeStyles(MutableComponent component, Style style) {
        if (style.isEmpty()) {
            return component;
        }
        Style style1 = component.getStyle();
        if (style1.isEmpty()) {
            return component.setStyle(style);
        }
        return style1.equals(style) ? component : component.setStyle(style1.applyTo(style));
    }

    @CheckReturnValue
    public static Component mergeStyles(Component component, Style style) {
        if (style.isEmpty()) {
            return component;
        }
        Style style1 = component.getStyle();
        if (style1.isEmpty()) {
            return component.copy().setStyle(style);
        }
        return style1.equals(style) ? component : component.copy().setStyle(style1.applyTo(style));
    }

    @Deprecated
    @DoNotUse
    public static Optional<MutableComponent> updateForEntity(@Nullable CommandSourceStack source, Optional<Component> optionalComponent, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        return optionalComponent.isPresent() ? Optional.of(ComponentUtils.updateForEntity(source, optionalComponent.get(), entity, recursionDepth)) : Optional.empty();
    }

    public static Optional<MutableComponent> updateSeparatorForEntity(@Nullable CommandSourceStack source, Optional<Component> text, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        if (text.isEmpty() || !ComponentUtils.isValidSelector(text.get())) {
            return Optional.empty();
        }
        return Optional.of(ComponentUtils.updateForEntity(source, text.get(), sender, depth));
    }

    public static boolean isValidSelector(Component component) {
        ComponentContents contents = component.getContents();
        if (contents instanceof NbtContents || contents instanceof SelectorContents) {
            return false;
        }
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)contents;
            for (Object arg : translatableContents.getArgs()) {
                Component argumentAsComponent;
                if (!(arg instanceof Component) || ComponentUtils.isValidSelector(argumentAsComponent = (Component)arg)) continue;
                return false;
            }
        }
        return true;
    }

    public static MutableComponent updateForEntity(@Nullable CommandSourceStack source, Component component, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (recursionDepth > 100) {
            return component.copy();
        }
        if (component instanceof AdventureComponent) {
            AdventureComponent adventureComponent = (AdventureComponent)component;
            component = adventureComponent.deepConverted();
        }
        MutableComponent mutableComponent = component.getContents().resolve(source, entity, recursionDepth + 1);
        for (Component component1 : component.getSiblings()) {
            mutableComponent.append(ComponentUtils.updateForEntity(source, component1, entity, recursionDepth + 1));
        }
        return mutableComponent.withStyle(ComponentUtils.resolveStyle(source, component.getStyle(), entity, recursionDepth));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Style resolveStyle(@Nullable CommandSourceStack source, Style style, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        HoverEvent hoverEvent = style.getHoverEvent();
        if (!(hoverEvent instanceof HoverEvent.ShowText)) return style;
        HoverEvent.ShowText showText = (HoverEvent.ShowText)hoverEvent;
        try {
            Component component;
            Component hoverEvent1 = component = showText.value();
            HoverEvent.ShowText hoverEvent1x = new HoverEvent.ShowText(ComponentUtils.updateForEntity(source, hoverEvent1, entity, recursionDepth + 1));
            return style.withHoverEvent(hoverEvent1x);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static Component formatList(Collection<String> elements) {
        return ComponentUtils.formatAndSortList(elements, content -> Component.literal(content).withStyle(ChatFormatting.GREEN));
    }

    public static <T extends Comparable<T>> Component formatAndSortList(Collection<T> elements, Function<T, Component> componentExtractor) {
        if (elements.isEmpty()) {
            return CommonComponents.EMPTY;
        }
        if (elements.size() == 1) {
            return componentExtractor.apply((Comparable)elements.iterator().next());
        }
        ArrayList list = Lists.newArrayList(elements);
        list.sort(Comparable::compareTo);
        return ComponentUtils.formatList(list, componentExtractor);
    }

    public static <T> Component formatList(Collection<? extends T> elements, Function<T, Component> componentExtractor) {
        return ComponentUtils.formatList(elements, DEFAULT_SEPARATOR, componentExtractor);
    }

    public static <T> MutableComponent formatList(Collection<? extends T> elements, Optional<? extends Component> optionalSeparator, Function<T, Component> componentExtractor) {
        return ComponentUtils.formatList(elements, (Component)DataFixUtils.orElse(optionalSeparator, (Object)DEFAULT_SEPARATOR), componentExtractor);
    }

    public static Component formatList(Collection<? extends Component> elements, Component separator) {
        return ComponentUtils.formatList(elements, separator, Function.identity());
    }

    public static <T> MutableComponent formatList(Collection<? extends T> elements, Component separator, Function<T, Component> componentExtractor) {
        if (elements.isEmpty()) {
            return Component.empty();
        }
        if (elements.size() == 1) {
            return componentExtractor.apply(elements.iterator().next()).copy();
        }
        MutableComponent mutableComponent = Component.empty();
        boolean flag = true;
        for (T object : elements) {
            if (!flag) {
                mutableComponent.append(separator);
            }
            mutableComponent.append(componentExtractor.apply(object));
            flag = false;
        }
        return mutableComponent;
    }

    public static MutableComponent wrapInSquareBrackets(Component toWrap) {
        return Component.translatable("chat.square_brackets", toWrap);
    }

    public static Component fromMessage(Message message) {
        Component component;
        if (message instanceof Component) {
            Component component2 = (Component)message;
            component = component2;
        } else {
            component = Component.literal(message.getString());
        }
        return component;
    }

    public static boolean isTranslationResolvable(@Nullable Component component) {
        ComponentContents componentContents;
        if (component != null && (componentContents = component.getContents()) instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            String key = translatableContents.getKey();
            String fallback = translatableContents.getFallback();
            return fallback != null || Language.getInstance().has(key);
        }
        return true;
    }

    public static MutableComponent copyOnClickText(String text) {
        return ComponentUtils.wrapInSquareBrackets(Component.literal(text).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent.CopyToClipboard(text)).withHoverEvent(new HoverEvent.ShowText(Component.translatable("chat.copy.click"))).withInsertion(text)));
    }
}

