/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat.contents;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.data.DataSource;
import net.minecraft.network.chat.contents.data.DataSources;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.entity.Entity;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class NbtContents
implements ComponentContents {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<NbtContents> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("nbt").forGetter(NbtContents::getNbtPath), (App)Codec.BOOL.lenientOptionalFieldOf("interpret", (Object)false).forGetter(NbtContents::isInterpreting), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("separator").forGetter(NbtContents::getSeparator), (App)DataSources.CODEC.forGetter(NbtContents::getDataSource)).apply((Applicative)instance, NbtContents::new));
    private final boolean interpreting;
    private final Optional<Component> separator;
    private final String nbtPathPattern;
    private final DataSource dataSource;
    protected final @Nullable NbtPathArgument.NbtPath compiledNbtPath;

    public NbtContents(String nbtPathPattern, boolean interpreting, Optional<Component> separator, DataSource dataSource) {
        this(nbtPathPattern, NbtContents.compileNbtPath(nbtPathPattern), interpreting, separator, dataSource);
    }

    private NbtContents(String nbtPathPattern, @Nullable NbtPathArgument.NbtPath compiledNbtPath, boolean interpreting, Optional<Component> separator, DataSource dataSource) {
        this.nbtPathPattern = nbtPathPattern;
        this.compiledNbtPath = compiledNbtPath;
        this.interpreting = interpreting;
        this.separator = separator;
        this.dataSource = dataSource;
    }

    private static @Nullable NbtPathArgument.NbtPath compileNbtPath(String nbtPathPattern) {
        try {
            return new NbtPathArgument().parse(new StringReader(nbtPathPattern));
        }
        catch (CommandSyntaxException var2) {
            return null;
        }
    }

    public String getNbtPath() {
        return this.nbtPathPattern;
    }

    public boolean isInterpreting() {
        return this.interpreting;
    }

    public Optional<Component> getSeparator() {
        return this.separator;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof NbtContents)) return false;
        NbtContents nbtContents = (NbtContents)other;
        if (!this.dataSource.equals(nbtContents.dataSource)) return false;
        if (!this.separator.equals(nbtContents.separator)) return false;
        if (this.interpreting != nbtContents.interpreting) return false;
        if (!this.nbtPathPattern.equals(nbtContents.nbtPathPattern)) return false;
        return true;
    }

    public int hashCode() {
        int i = this.interpreting ? 1 : 0;
        i = 31 * i + this.separator.hashCode();
        i = 31 * i + this.nbtPathPattern.hashCode();
        return 31 * i + this.dataSource.hashCode();
    }

    public String toString() {
        return "nbt{" + String.valueOf(this.dataSource) + ", interpreting=" + this.interpreting + ", separator=" + String.valueOf(this.separator) + "}";
    }

    @Override
    public MutableComponent resolve(@Nullable CommandSourceStack source, @Nullable Entity entity, int recursionDepth) throws CommandSyntaxException {
        if (source != null && this.compiledNbtPath != null) {
            Stream<String> stream = this.dataSource.getData(source).flatMap(tag -> {
                try {
                    return this.compiledNbtPath.get((Tag)tag).stream();
                }
                catch (CommandSyntaxException var3x) {
                    return Stream.empty();
                }
            });
            if (this.interpreting) {
                RegistryOps<Tag> registryOps = source.registryAccess().createSerializationContext(NbtOps.INSTANCE);
                Component component = (Component)DataFixUtils.orElse(ComponentUtils.updateSeparatorForEntity(source, this.separator, entity, recursionDepth), (Object)ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR);
                return stream.flatMap(tag -> {
                    try {
                        Component component1 = (Component)ComponentSerialization.CODEC.parse((DynamicOps)registryOps, tag).getOrThrow();
                        return Stream.of(ComponentUtils.updateForEntity(source, component1, entity, recursionDepth));
                    }
                    catch (Exception var6x) {
                        LOGGER.warn("Failed to parse component: {}", tag, (Object)var6x);
                        return Stream.of(new MutableComponent[0]);
                    }
                }).reduce((mutableComponent, component1) -> mutableComponent.append(component).append((Component)component1)).orElseGet(Component::empty);
            }
            Stream<String> stream1 = stream.map(NbtContents::asString);
            return ComponentUtils.updateSeparatorForEntity(source, this.separator, entity, recursionDepth).map(mutableComponent -> stream1.map(Component::literal).reduce((mutableComponent1, otherMutableComponent) -> mutableComponent1.append((Component)mutableComponent).append((Component)otherMutableComponent)).orElseGet(Component::empty)).orElseGet(() -> Component.literal(stream1.collect(Collectors.joining(", "))));
        }
        return Component.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String asString(Tag tag) {
        String string;
        if (!(tag instanceof StringTag)) {
            string = tag.toString();
            return string;
        }
        StringTag stringTag = (StringTag)tag;
        try {
            String string2;
            String var5;
            string = var5 = (string2 = stringTag.value());
            return string;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public MapCodec<NbtContents> codec() {
        return MAP_CODEC;
    }
}

