/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import org.jspecify.annotations.Nullable;

public interface BundlerInfo {
    public static final int BUNDLE_SIZE_LIMIT = 4096;

    public static <T extends PacketListener, P extends BundlePacket<? super T>> BundlerInfo createForPacket(final PacketType<P> type, final Function<Iterable<Packet<? super T>>, P> bundler, final BundleDelimiterPacket<? super T> delimiterPacket) {
        return new BundlerInfo(){

            @Override
            public void unbundlePacket(Packet<?> packet, Consumer<Packet<?>> consumer) {
                if (packet.type() == type) {
                    BundlePacket bundlePacket = (BundlePacket)packet;
                    consumer.accept(delimiterPacket);
                    bundlePacket.subPackets().forEach(consumer);
                    consumer.accept(delimiterPacket);
                } else {
                    consumer.accept(packet);
                }
            }

            @Override
            public @Nullable Bundler startPacketBundling(Packet<?> packet) {
                return packet == delimiterPacket ? new Bundler(){
                    private final List<Packet<? super T>> bundlePackets = new ArrayList();

                    @Override
                    public @Nullable Packet<?> addPacket(Packet<?> subPacket) {
                        if (subPacket == delimiterPacket) {
                            return (Packet)bundler.apply(this.bundlePackets);
                        }
                        if (this.bundlePackets.size() >= 4096) {
                            throw new IllegalStateException("Too many packets in a bundle");
                        }
                        this.bundlePackets.add(subPacket);
                        return null;
                    }
                } : null;
            }
        };
    }

    public void unbundlePacket(Packet<?> var1, Consumer<Packet<?>> var2);

    public @Nullable Bundler startPacketBundling(Packet<?> var1);

    public static interface Bundler {
        public @Nullable Packet<?> addPacket(Packet<?> var1);
    }
}

