/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;

public record DiscardedPayload(Identifier id, byte[] data) implements CustomPacketPayload
{
    public static <T extends FriendlyByteBuf> StreamCodec<T, DiscardedPayload> codec(Identifier id, int maxSize) {
        return CustomPacketPayload.codec((T value, B output) -> output.writeBytes(value.data), (B buffer) -> {
            int i = buffer.readableBytes();
            if (i >= 0 && i <= maxSize) {
                byte[] data = new byte[i];
                buffer.readBytes(data);
                return new DiscardedPayload(id, data);
            }
            throw new IllegalArgumentException("Payload may not be larger than " + maxSize + " bytes");
        });
    }

    public CustomPacketPayload.Type<DiscardedPayload> type() {
        return new CustomPacketPayload.Type<DiscardedPayload>(this.id);
    }
}

