/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.world.phys.Vec3;

public class VecDeltaCodec {
    private static final double TRUNCATION_STEPS = 4096.0;
    public Vec3 base = Vec3.ZERO;

    @VisibleForTesting
    static long encode(double value) {
        return Math.round(value * 4096.0);
    }

    @VisibleForTesting
    static double decode(long value) {
        return (double)value / 4096.0;
    }

    public Vec3 decode(long x, long y, long z) {
        if (x == 0L && y == 0L && z == 0L) {
            return this.base;
        }
        double d = x == 0L ? this.base.x : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.x) + x);
        double d1 = y == 0L ? this.base.y : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.y) + y);
        double d2 = z == 0L ? this.base.z : VecDeltaCodec.decode(VecDeltaCodec.encode(this.base.z) + z);
        return new Vec3(d, d1, d2);
    }

    public long encodeX(Vec3 value) {
        return VecDeltaCodec.encode(value.x) - VecDeltaCodec.encode(this.base.x);
    }

    public long encodeY(Vec3 value) {
        return VecDeltaCodec.encode(value.y) - VecDeltaCodec.encode(this.base.y);
    }

    public long encodeZ(Vec3 value) {
        return VecDeltaCodec.encode(value.z) - VecDeltaCodec.encode(this.base.z);
    }

    public Vec3 delta(Vec3 value) {
        return value.subtract(this.base);
    }

    public void setBase(Vec3 base) {
        this.base = base;
    }

    public Vec3 getBase() {
        return this.base;
    }
}

