/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener<Advancement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<Identifier, AdvancementHolder> advancements = new HashMap<Identifier, AdvancementHolder>();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider registries) {
        super(registries, Advancement.CODEC, Registries.ADVANCEMENT);
        this.registries = registries;
    }

    @Override
    protected void apply(Map<Identifier, Advancement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((identifier, advancement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(identifier.toString()) || SpigotConfig.disabledAdvancements.contains(identifier.getNamespace()))) {
                return;
            }
            this.validate((Identifier)identifier, (Advancement)advancement);
            builder.put(identifier, (Object)new AdvancementHolder((Identifier)identifier, (Advancement)advancement));
        });
        this.advancements = new HashMap<Identifier, AdvancementHolder>((Map<Identifier, AdvancementHolder>)builder.buildOrThrow());
        AdvancementTree advancementTree = new AdvancementTree();
        advancementTree.addAll(this.advancements.values());
        LOGGER.info("Loaded {} advancements", (Object)advancementTree.nodes().size());
        for (AdvancementNode advancementNode : advancementTree.roots()) {
            if (!advancementNode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementNode);
        }
        this.tree = advancementTree;
    }

    private void validate(Identifier location, Advancement advancement) {
        ProblemReporter.Collector collector = new ProblemReporter.Collector();
        advancement.validate(collector, this.registries);
        if (!collector.isEmpty()) {
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)location, (Object)collector.getReport());
        }
    }

    public @Nullable AdvancementHolder get(Identifier location) {
        return this.advancements.get(location);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

