/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ServicesKeySet;
import com.mojang.authlib.yggdrasil.ServicesKeyType;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.profile.PaperFilledProfileCache;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import joptsimple.OptionSet;
import net.minecraft.server.players.CachedUserNameToIdResolver;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.server.players.UserNameToIdResolver;
import net.minecraft.util.SignatureValidator;
import org.jspecify.annotations.Nullable;

public record Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, UserNameToIdResolver nameToIdCache, ProfileResolver profileResolver, @javax.annotation.Nullable PaperServices paper) {
    @javax.annotation.Nullable
    private final PaperServices paper;
    public static final String USERID_CACHE_FILE = "usercache.json";

    public Services(MinecraftSessionService sessionService, ServicesKeySet servicesKeySet, GameProfileRepository profileRepository, UserNameToIdResolver nameToIdCache, ProfileResolver profileResolver) {
        this(sessionService, servicesKeySet, profileRepository, nameToIdCache, profileResolver, null);
    }

    public PaperServices paper() {
        return Objects.requireNonNull(this.paper);
    }

    public static Services create(YggdrasilAuthenticationService authenticationService, File profileRepository, File userCacheFile, OptionSet optionSet) throws Exception {
        MinecraftSessionService minecraftSessionService = authenticationService.createMinecraftSessionService();
        GameProfileRepository gameProfileRepository = authenticationService.createProfileRepository();
        CachedUserNameToIdResolver userNameToIdResolver = new CachedUserNameToIdResolver(gameProfileRepository, userCacheFile);
        Path legacyConfigPath = ((File)optionSet.valueOf("paper-settings")).toPath();
        Path configDirPath = ((File)optionSet.valueOf("paper-settings-directory")).toPath();
        PaperConfigurations paperConfigurations = PaperConfigurations.setup(legacyConfigPath, configDirPath, profileRepository.toPath(), (File)optionSet.valueOf("spigot-settings"));
        PaperServices paperServices = new PaperServices(paperConfigurations, new PaperFilledProfileCache());
        ProfileResolver.Cached profileResolver = new ProfileResolver.Cached(minecraftSessionService, userNameToIdResolver, paperServices.filledProfileCache());
        return new Services(minecraftSessionService, authenticationService.getServicesKeySet(), gameProfileRepository, userNameToIdResolver, profileResolver, paperServices);
    }

    public @Nullable SignatureValidator profileKeySignatureValidator() {
        return SignatureValidator.from(this.servicesKeySet, ServicesKeyType.PROFILE_KEY);
    }

    public boolean canValidateProfileKeys() {
        return !this.servicesKeySet.keys(ServicesKeyType.PROFILE_KEY).isEmpty();
    }

    public record PaperServices(PaperConfigurations configurations, PaperFilledProfileCache filledProfileCache) {
    }
}

