/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.jspecify.annotations.Nullable;

public class EffectCommands {
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.give.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_CLEAR_SPECIFIC_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.effect.clear.specific.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("effect").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(commandContext -> EffectCommands.clearEffects((CommandSourceStack)commandContext.getSource(), (Collection<? extends Entity>)ImmutableList.of((Object)((CommandSourceStack)commandContext.getSource()).getEntityOrException())))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.entities()).executes(context1 -> EffectCommands.clearEffects((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets")))).then(Commands.argument("effect", ResourceArgument.resource(context, Registries.MOB_EFFECT)).executes(context1 -> EffectCommands.clearEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"))))))).then(Commands.literal("give").then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("effect", ResourceArgument.resource(context, Registries.MOB_EFFECT)).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), null, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("seconds", IntegerArgumentType.integer((int)1, (int)1000000)).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"seconds"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles"))))))).then(((LiteralArgumentBuilder)Commands.literal("infinite").executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), -1, 0, true))).then(((RequiredArgumentBuilder)Commands.argument("amplifier", IntegerArgumentType.integer((int)0, (int)255)).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), true))).then(Commands.argument("hideParticles", BoolArgumentType.bool()).executes(context1 -> EffectCommands.giveEffect((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), ResourceArgument.getMobEffect((CommandContext<CommandSourceStack>)context1, "effect"), -1, IntegerArgumentType.getInteger((CommandContext)context1, (String)"amplifier"), !BoolArgumentType.getBool((CommandContext)context1, (String)"hideParticles")))))))))));
    }

    private static int giveEffect(CommandSourceStack source, Collection<? extends Entity> targets, Holder<MobEffect> effect, @Nullable Integer seconds, int amplifier, boolean showParticles) throws CommandSyntaxException {
        MobEffect mobEffect = effect.value();
        int i = 0;
        int i1 = seconds != null ? (mobEffect.isInstantenous() ? seconds : (seconds == -1 ? -1 : seconds * 20)) : (mobEffect.isInstantenous() ? 1 : 600);
        for (Entity entity : targets) {
            MobEffectInstance mobEffectInstance;
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).addEffect(mobEffectInstance = new MobEffectInstance(effect, i1, amplifier, false, showParticles), source.getEntity(), EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.give.success.single", mobEffect.getDisplayName(), ((Entity)targets.iterator().next()).getDisplayName(), i1 / 20), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.give.success.multiple", mobEffect.getDisplayName(), targets.size(), i1 / 20), true);
        }
        return i;
    }

    private static int clearEffects(CommandSourceStack source, Collection<? extends Entity> targets) throws CommandSyntaxException {
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeAllEffects(EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.single", ((Entity)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.everything.success.multiple", targets.size()), true);
        }
        return i;
    }

    private static int clearEffect(CommandSourceStack source, Collection<? extends Entity> targets, Holder<MobEffect> effect) throws CommandSyntaxException {
        MobEffect mobEffect = effect.value();
        int i = 0;
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).removeEffect(effect, EntityPotionEffectEvent.Cause.COMMAND)) continue;
            ++i;
        }
        if (i == 0) {
            throw ERROR_CLEAR_SPECIFIC_FAILED.create();
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.single", mobEffect.getDisplayName(), ((Entity)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.effect.clear.specific.success.multiple", mobEffect.getDisplayName(), targets.size()), true);
        }
        return i;
    }
}

