/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.mutable.MutableInt;

public class FillBiomeCommand {
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.unloaded"));
    private static final Dynamic2CommandExceptionType ERROR_VOLUME_TOO_LARGE = new Dynamic2CommandExceptionType((maxBlocks, specifiedBlocks) -> Component.translatableEscape("commands.fillbiome.toobig", maxBlocks, specifiedBlocks));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fillbiome").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("from", BlockPosArgument.blockPos()).then(Commands.argument("to", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("biome", ResourceArgument.resource(context, Registries.BIOME)).executes(context1 -> FillBiomeCommand.fill((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "to"), ResourceArgument.getResource((CommandContext<CommandSourceStack>)context1, "biome", Registries.BIOME), holder -> true))).then(Commands.literal("replace").then(Commands.argument("filter", ResourceOrTagArgument.resourceOrTag(context, Registries.BIOME)).executes(context1 -> FillBiomeCommand.fill((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "to"), ResourceArgument.getResource((CommandContext<CommandSourceStack>)context1, "biome", Registries.BIOME), ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandSourceStack>)context1, "filter", Registries.BIOME))))))))));
    }

    private static int quantize(int value) {
        return QuartPos.toBlock(QuartPos.fromBlock(value));
    }

    private static BlockPos quantize(BlockPos pos) {
        return new BlockPos(FillBiomeCommand.quantize(pos.getX()), FillBiomeCommand.quantize(pos.getY()), FillBiomeCommand.quantize(pos.getZ()));
    }

    private static BiomeResolver makeResolver(MutableInt biomeEntries, ChunkAccess chunk, BoundingBox targetRegion, Holder<Biome> replacementBiome, Predicate<Holder<Biome>> filter) {
        return (x, y, z, sampler) -> {
            int blockPosX = QuartPos.toBlock(x);
            int blockPosY = QuartPos.toBlock(y);
            int blockPosZ = QuartPos.toBlock(z);
            Holder<Biome> noiseBiome = chunk.getNoiseBiome(x, y, z);
            if (targetRegion.isInside(blockPosX, blockPosY, blockPosZ) && filter.test(noiseBiome)) {
                biomeEntries.increment();
                return replacementBiome;
            }
            return noiseBiome;
        };
    }

    public static Either<Integer, CommandSyntaxException> fill(ServerLevel level, BlockPos from, BlockPos to, Holder<Biome> biome) {
        return FillBiomeCommand.fill(level, from, to, biome, holder -> true, supplier -> {});
    }

    public static Either<Integer, CommandSyntaxException> fill(ServerLevel level, BlockPos from, BlockPos to, Holder<Biome> biome, Predicate<Holder<Biome>> filter, Consumer<Supplier<Component>> messageOutput) {
        int i1;
        BlockPos blockPos1;
        BlockPos blockPos = FillBiomeCommand.quantize(from);
        BoundingBox boundingBox = BoundingBox.fromCorners(blockPos, blockPos1 = FillBiomeCommand.quantize(to));
        int i = boundingBox.getXSpan() * boundingBox.getYSpan() * boundingBox.getZSpan();
        if (i > (i1 = level.getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS).intValue())) {
            return Either.right(ERROR_VOLUME_TOO_LARGE.create((Object)i1, (Object)i));
        }
        ArrayList<ChunkAccess> list = new ArrayList<ChunkAccess>();
        for (int sectionPosMinZ = SectionPos.blockToSectionCoord(boundingBox.minZ()); sectionPosMinZ <= SectionPos.blockToSectionCoord(boundingBox.maxZ()); ++sectionPosMinZ) {
            for (int sectionPosMinX = SectionPos.blockToSectionCoord(boundingBox.minX()); sectionPosMinX <= SectionPos.blockToSectionCoord(boundingBox.maxX()); ++sectionPosMinX) {
                ChunkAccess chunk = level.getChunk(sectionPosMinX, sectionPosMinZ, ChunkStatus.FULL, false);
                if (chunk == null) {
                    return Either.right(ERROR_NOT_LOADED.create());
                }
                list.add(chunk);
            }
        }
        MutableInt mutableInt = new MutableInt(0);
        for (ChunkAccess chunk : list) {
            chunk.fillBiomesFromNoise(FillBiomeCommand.makeResolver(mutableInt, chunk, boundingBox, biome, filter), level.getChunkSource().randomState().sampler());
            chunk.markUnsaved();
        }
        level.getChunkSource().chunkMap.resendBiomesForChunks(list);
        messageOutput.accept(() -> Component.translatable("commands.fillbiome.success.count", mutableInt.intValue(), boundingBox.minX(), boundingBox.minY(), boundingBox.minZ(), boundingBox.maxX(), boundingBox.maxY(), boundingBox.maxZ()));
        return Either.left(mutableInt.intValue());
    }

    private static int fill(CommandSourceStack source, BlockPos from, BlockPos to, Holder.Reference<Biome> biome, Predicate<Holder<Biome>> filter) throws CommandSyntaxException {
        Either<Integer, CommandSyntaxException> either = FillBiomeCommand.fill(source.getLevel(), from, to, biome, filter, supplier -> source.sendSuccess((Supplier<Component>)supplier, true));
        Optional<CommandSyntaxException> optional = either.right();
        if (optional.isPresent()) {
            throw optional.get();
        }
        return either.left().get();
    }
}

