/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.PlayerTeam;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SpreadPlayersCommand {
    private static final int MAX_ITERATION_COUNT = 10000;
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_TEAMS = new Dynamic4CommandExceptionType((teamCount, x, z, suggestedSpread) -> Component.translatableEscape("commands.spreadplayers.failed.teams", teamCount, x, z, suggestedSpread));
    private static final Dynamic4CommandExceptionType ERROR_FAILED_TO_SPREAD_ENTITIES = new Dynamic4CommandExceptionType((entityCount, x, z, suggestedSpread) -> Component.translatableEscape("commands.spreadplayers.failed.entities", entityCount, x, z, suggestedSpread));
    private static final Dynamic2CommandExceptionType ERROR_INVALID_MAX_HEIGHT = new Dynamic2CommandExceptionType((maxHeight, worldMin) -> Component.translatableEscape("commands.spreadplayers.failed.invalid.height", maxHeight, worldMin));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spreadplayers").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("center", Vec2Argument.vec2()).then(Commands.argument("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.argument("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(commandContext -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)commandContext.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)commandContext, "center"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"maxRange"), ((CommandSourceStack)commandContext.getSource()).getLevel().getMaxY() + 1, BoolArgumentType.getBool((CommandContext)commandContext, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)commandContext, "targets")))))).then(Commands.literal("under").then(Commands.argument("maxHeight", IntegerArgumentType.integer()).then(Commands.argument("respectTeams", BoolArgumentType.bool()).then(Commands.argument("targets", EntityArgument.entities()).executes(context -> SpreadPlayersCommand.spreadPlayers((CommandSourceStack)context.getSource(), Vec2Argument.getVec2((CommandContext<CommandSourceStack>)context, "center"), FloatArgumentType.getFloat((CommandContext)context, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)context, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)context, (String)"respectTeams"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context, "targets"))))))))))));
    }

    private static int spreadPlayers(CommandSourceStack source, Vec2 center, float spreadDistance, float maxRange, int maxHeight, boolean respectTeams, Collection<? extends Entity> targets) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        int minY = level.getMinY();
        if (maxHeight < minY) {
            throw ERROR_INVALID_MAX_HEIGHT.create((Object)maxHeight, (Object)minY);
        }
        RandomSource randomSource = RandomSource.create();
        double d = center.x - maxRange;
        double d1 = center.y - maxRange;
        double d2 = center.x + maxRange;
        double d3 = center.y + maxRange;
        Position[] positions = SpreadPlayersCommand.createInitialPositions(randomSource, respectTeams ? SpreadPlayersCommand.getNumberOfTeams(targets) : targets.size(), d, d1, d2, d3);
        SpreadPlayersCommand.spreadPositions(center, spreadDistance, level, randomSource, d, d1, d2, d3, maxHeight, positions, respectTeams);
        double d4 = SpreadPlayersCommand.setPlayerPositions(targets, level, positions, maxHeight, respectTeams);
        source.sendSuccess(() -> Component.translatable("commands.spreadplayers.success." + (respectTeams ? "teams" : "entities"), positions.length, Float.valueOf(center.x), Float.valueOf(center.y), String.format(Locale.ROOT, "%.2f", d4)), true);
        return positions.length;
    }

    private static int getNumberOfTeams(Collection<? extends Entity> entities) {
        HashSet set = Sets.newHashSet();
        for (Entity entity : entities) {
            if (entity instanceof Player) {
                set.add(entity.getTeam());
                continue;
            }
            set.add(null);
        }
        return set.size();
    }

    private static void spreadPositions(Vec2 center, double spreadDistance, ServerLevel level, RandomSource random, double minX, double minZ, double maxX, double maxZ, int maxHeight, Position[] positions, boolean respectTeams) throws CommandSyntaxException {
        int i;
        boolean flag = true;
        double d = 3.4028234663852886E38;
        for (i = 0; i < 10000 && flag; ++i) {
            flag = false;
            d = 3.4028234663852886E38;
            for (int i1 = 0; i1 < positions.length; ++i1) {
                Position position = positions[i1];
                int i2 = 0;
                Position position1 = new Position();
                for (int i3 = 0; i3 < positions.length; ++i3) {
                    if (i1 == i3) continue;
                    Position position2 = positions[i3];
                    double d1 = position.dist(position2);
                    d = Math.min(d1, d);
                    if (!(d1 < spreadDistance)) continue;
                    ++i2;
                    position1.x += position2.x - position.x;
                    position1.z += position2.z - position.z;
                }
                if (i2 > 0) {
                    position1.x /= (double)i2;
                    position1.z /= (double)i2;
                    double length = position1.getLength();
                    if (length > 0.0) {
                        position1.normalize();
                        position.moveAway(position1);
                    } else {
                        position.randomize(random, minX, minZ, maxX, maxZ);
                    }
                    flag = true;
                }
                if (!position.clamp(minX, minZ, maxX, maxZ)) continue;
                flag = true;
            }
            if (flag) continue;
            for (Position position1 : positions) {
                if (position1.isSafe(level, maxHeight)) continue;
                position1.randomize(random, minX, minZ, maxX, maxZ);
                flag = true;
            }
        }
        if (d == 3.4028234663852886E38) {
            d = 0.0;
        }
        if (i >= 10000) {
            if (respectTeams) {
                throw ERROR_FAILED_TO_SPREAD_TEAMS.create((Object)positions.length, (Object)Float.valueOf(center.x), (Object)Float.valueOf(center.y), (Object)String.format(Locale.ROOT, "%.2f", d));
            }
            throw ERROR_FAILED_TO_SPREAD_ENTITIES.create((Object)positions.length, (Object)Float.valueOf(center.x), (Object)Float.valueOf(center.y), (Object)String.format(Locale.ROOT, "%.2f", d));
        }
    }

    private static double setPlayerPositions(Collection<? extends Entity> targets, ServerLevel level, Position[] positions, int maxHeight, boolean respectTeams) {
        double d = 0.0;
        int i = 0;
        HashMap map = Maps.newHashMap();
        for (Entity entity : targets) {
            Position position;
            if (respectTeams) {
                PlayerTeam team;
                PlayerTeam playerTeam = team = entity instanceof Player ? entity.getTeam() : null;
                if (!map.containsKey(team)) {
                    map.put(team, positions[i++]);
                }
                position = (Position)map.get(team);
            } else {
                position = positions[i++];
            }
            entity.teleportTo(level, (double)Mth.floor(position.x) + 0.5, position.getSpawnY(level, maxHeight), (double)Mth.floor(position.z) + 0.5, Set.of(), entity.getYRot(), entity.getXRot(), true, PlayerTeleportEvent.TeleportCause.COMMAND);
            double d1 = Double.MAX_VALUE;
            for (Position position1 : positions) {
                if (position == position1) continue;
                double d2 = position.dist(position1);
                d1 = Math.min(d2, d1);
            }
            d += d1;
        }
        return targets.size() < 2 ? 0.0 : d / (double)targets.size();
    }

    private static Position[] createInitialPositions(RandomSource random, int count, double minX, double minZ, double maxX, double maxZ) {
        Position[] positions = new Position[count];
        for (int i = 0; i < positions.length; ++i) {
            Position position = new Position();
            position.randomize(random, minX, minZ, maxX, maxZ);
            positions[i] = position;
        }
        return positions;
    }

    static class Position {
        double x;
        double z;

        Position() {
        }

        double dist(Position other) {
            double d = this.x - other.x;
            double d1 = this.z - other.z;
            return Math.sqrt(d * d + d1 * d1);
        }

        void normalize() {
            double length = this.getLength();
            this.x /= length;
            this.z /= length;
        }

        double getLength() {
            return Math.sqrt(this.x * this.x + this.z * this.z);
        }

        public void moveAway(Position other) {
            this.x -= other.x;
            this.z -= other.z;
        }

        public boolean clamp(double minX, double minZ, double maxX, double maxZ) {
            boolean flag = false;
            if (this.x < minX) {
                this.x = minX;
                flag = true;
            } else if (this.x > maxX) {
                this.x = maxX;
                flag = true;
            }
            if (this.z < minZ) {
                this.z = minZ;
                flag = true;
            } else if (this.z > maxZ) {
                this.z = maxZ;
                flag = true;
            }
            return flag;
        }

        public int getSpawnY(BlockGetter level, int y) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.x, (double)(y + 1), this.z);
            boolean isAir = level.getBlockState(mutableBlockPos).isAir();
            mutableBlockPos.move(Direction.DOWN);
            boolean isAir1 = level.getBlockState(mutableBlockPos).isAir();
            while (mutableBlockPos.getY() > level.getMinY()) {
                mutableBlockPos.move(Direction.DOWN);
                boolean isAir2 = level.getBlockState(mutableBlockPos).isAir();
                if (!isAir2 && isAir1 && isAir) {
                    return mutableBlockPos.getY() + 1;
                }
                isAir = isAir1;
                isAir1 = isAir2;
            }
            return y + 1;
        }

        public boolean isSafe(BlockGetter level, int y) {
            BlockPos blockPos = BlockPos.containing(this.x, this.getSpawnY(level, y) - 1, this.z);
            BlockState blockState = level.getBlockState(blockPos);
            return blockPos.getY() < y && !blockState.liquid() && !blockState.is(BlockTags.FIRE);
        }

        public void randomize(RandomSource random, double minX, double minZ, double maxX, double maxZ) {
            this.x = Mth.nextDouble(random, minX, maxX);
            this.z = Mth.nextDouble(random, minZ, maxZ);
        }
    }
}

