/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;

public class BanlistService {
    private static final String BAN_SOURCE = "Management server";

    public static List<UserBanDto> get(MinecraftApi api) {
        return api.banListService().getUserBanEntries().stream().filter(userBanListEntry -> userBanListEntry.getUser() != null).map(UserBan::from).map(UserBanDto::from).toList();
    }

    public static List<UserBanDto> add(MinecraftApi api, List<UserBanDto> users, ClientInfo client) {
        List<CompletableFuture> list = users.stream().map(userBanDto -> api.playerListService().getUser(userBanDto.player().id(), userBanDto.player().name()).thenApply(optional1 -> optional1.map(userBanDto::toUserBan))).toList();
        for (Optional optional : Util.sequence(list).join()) {
            if (optional.isEmpty()) continue;
            UserBan userBan = (UserBan)optional.get();
            api.banListService().addUserBan(userBan.toBanEntry(), client);
            ServerPlayer player = api.playerListService().getPlayer(((UserBan)optional.get()).player().id());
            if (player == null) continue;
            player.connection.disconnect(Component.translatable("multiplayer.disconnect.banned"));
        }
        return BanlistService.get(api);
    }

    public static List<UserBanDto> clear(MinecraftApi api, ClientInfo client) {
        api.banListService().clearUserBans(client);
        return BanlistService.get(api);
    }

    public static List<UserBanDto> remove(MinecraftApi api, List<PlayerDto> players, ClientInfo client) {
        List<CompletableFuture> list = players.stream().map(playerDto -> api.playerListService().getUser(playerDto.id(), playerDto.name())).toList();
        for (Optional optional : Util.sequence(list).join()) {
            if (optional.isEmpty()) continue;
            api.banListService().removeUserBan((NameAndId)optional.get(), client);
        }
        return BanlistService.get(api);
    }

    public static List<UserBanDto> set(MinecraftApi api, List<UserBanDto> users, ClientInfo client) {
        List<CompletableFuture> list = users.stream().map(userBanDto -> api.playerListService().getUser(userBanDto.player().id(), userBanDto.player().name()).thenApply(optional -> optional.map(userBanDto::toUserBan))).toList();
        Set set = Util.sequence(list).join().stream().flatMap(Optional::stream).collect(Collectors.toSet());
        Set set1 = api.banListService().getUserBanEntries().stream().filter(userBanListEntry -> userBanListEntry.getUser() != null).map(UserBan::from).collect(Collectors.toSet());
        set1.stream().filter(userBan -> !set.contains(userBan)).forEach(userBan -> api.banListService().removeUserBan(userBan.player(), client));
        set.stream().filter(userBan -> !set1.contains(userBan)).forEach(userBan -> {
            api.banListService().addUserBan(userBan.toBanEntry(), client);
            ServerPlayer player = api.playerListService().getPlayer(userBan.player().id());
            if (player != null) {
                player.connection.disconnect(Component.translatable("multiplayer.disconnect.banned"));
            }
        });
        return BanlistService.get(api);
    }

    record UserBan(NameAndId player, @Nullable String reason, String source, Optional<Instant> expires) {
        static UserBan from(UserBanListEntry entry) {
            return new UserBan(Objects.requireNonNull((NameAndId)entry.getUser()), entry.getReason(), entry.getSource(), Optional.ofNullable(entry.getExpires()).map(Date::toInstant));
        }

        UserBanListEntry toBanEntry() {
            return new UserBanListEntry(new NameAndId(this.player().id(), this.player().name()), null, this.source(), (Date)this.expires().map(Date::from).orElse(null), this.reason());
        }
    }

    public record UserBanDto(PlayerDto player, Optional<String> reason, Optional<String> source, Optional<Instant> expires) {
        public static final MapCodec<UserBanDto> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(UserBanDto::player), (App)Codec.STRING.optionalFieldOf("reason").forGetter(UserBanDto::reason), (App)Codec.STRING.optionalFieldOf("source").forGetter(UserBanDto::source), (App)ExtraCodecs.INSTANT_ISO8601.optionalFieldOf("expires").forGetter(UserBanDto::expires)).apply((Applicative)instance, UserBanDto::new));

        private static UserBanDto from(UserBan user) {
            return new UserBanDto(PlayerDto.from(user.player()), Optional.ofNullable(user.reason()), Optional.of(user.source()), user.expires());
        }

        public static UserBanDto from(UserBanListEntry entry) {
            return UserBanDto.from(UserBan.from(entry));
        }

        private UserBan toUserBan(NameAndId nameAndId) {
            return new UserBan(nameAndId, this.reason().orElse(null), this.source().orElse(BanlistService.BAN_SOURCE), this.expires());
        }
    }
}

