/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleType;

public class GameRulesService {
    public static List<GameRuleUpdate<?>> get(MinecraftApi api) {
        ArrayList list = new ArrayList();
        api.gameRuleService().getAvailableGameRules().forEach(gameRule -> GameRulesService.addGameRule(api, gameRule, list));
        return list;
    }

    private static <T> void addGameRule(MinecraftApi api, GameRule<T> rule, List<GameRuleUpdate<?>> updates) {
        T ruleValue = api.gameRuleService().getRuleValue(rule);
        updates.add(GameRulesService.getTypedRule(api, rule, Objects.requireNonNull(ruleValue)));
    }

    public static <T> GameRuleUpdate<T> getTypedRule(MinecraftApi api, GameRule<T> rule, T value) {
        return api.gameRuleService().getTypedRule(rule, value);
    }

    public static <T> GameRuleUpdate<T> update(MinecraftApi api, GameRuleUpdate<T> update, ClientInfo client) {
        return api.gameRuleService().updateGameRule(update, client);
    }

    public record GameRuleUpdate<T>(GameRule<T> gameRule, T value) {
        public static final Codec<GameRuleUpdate<?>> TYPED_CODEC = BuiltInRegistries.GAME_RULE.byNameCodec().dispatch("key", GameRuleUpdate::gameRule, GameRuleUpdate::getValueAndTypeCodec);
        public static final Codec<GameRuleUpdate<?>> CODEC = BuiltInRegistries.GAME_RULE.byNameCodec().dispatch("key", GameRuleUpdate::gameRule, GameRuleUpdate::getValueCodec);

        private static <T> MapCodec<? extends GameRuleUpdate<T>> getValueCodec(GameRule<T> gameRule) {
            return gameRule.valueCodec().fieldOf("value").xmap(object -> new GameRuleUpdate<Object>(gameRule, object), GameRuleUpdate::value);
        }

        private static <T> MapCodec<? extends GameRuleUpdate<T>> getValueAndTypeCodec(GameRule<T> gameRule) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)StringRepresentable.fromEnum(GameRuleType::values).fieldOf("type").forGetter(gameRuleUpdate -> gameRuleUpdate.gameRule.gameRuleType()), (App)gameRule.valueCodec().fieldOf("value").forGetter(GameRuleUpdate::value)).apply((Applicative)instance, (gameRuleType, object) -> GameRuleUpdate.getUntypedRule(gameRule, gameRuleType, object)));
        }

        private static <T> GameRuleUpdate<T> getUntypedRule(GameRule<T> gameRule, GameRuleType type, T value) {
            if (gameRule.gameRuleType() != type) {
                throw new InvalidParameterJsonRpcException("Stated type \"" + String.valueOf(type) + "\" mismatches with actual type \"" + String.valueOf(gameRule.gameRuleType()) + "\" of gamerule \"" + gameRule.id() + "\"");
            }
            return new GameRuleUpdate<T>(gameRule, value);
        }
    }
}

