/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.util.Util;

public class OperatorService {
    public static List<OperatorDto> get(MinecraftApi api) {
        return api.operatorListService().getEntries().stream().filter(serverOpListEntry -> serverOpListEntry.getUser() != null).map(OperatorDto::from).toList();
    }

    public static List<OperatorDto> clear(MinecraftApi api, ClientInfo client) {
        api.operatorListService().clear(client);
        return OperatorService.get(api);
    }

    public static List<OperatorDto> remove(MinecraftApi api, List<PlayerDto> players, ClientInfo client) {
        List<CompletableFuture> list = players.stream().map(playerDto -> api.playerListService().getUser(playerDto.id(), playerDto.name())).toList();
        for (Optional optional : Util.sequence(list).join()) {
            optional.ifPresent(nameAndId -> api.operatorListService().deop((NameAndId)nameAndId, client));
        }
        return OperatorService.get(api);
    }

    public static List<OperatorDto> add(MinecraftApi api, List<OperatorDto> operators, ClientInfo client) {
        List<CompletableFuture> list = operators.stream().map(operatorDto -> api.playerListService().getUser(operatorDto.player().id(), operatorDto.player().name()).thenApply(optional1 -> optional1.map(nameAndId -> new Op((NameAndId)nameAndId, operatorDto.permissionLevel(), operatorDto.bypassesPlayerLimit())))).toList();
        for (Optional optional : Util.sequence(list).join()) {
            optional.ifPresent(op -> api.operatorListService().op(op.user(), op.permissionLevel(), op.bypassesPlayerLimit(), client));
        }
        return OperatorService.get(api);
    }

    public static List<OperatorDto> set(MinecraftApi api, List<OperatorDto> operators, ClientInfo client) {
        List<CompletableFuture> list = operators.stream().map(operatorDto -> api.playerListService().getUser(operatorDto.player().id(), operatorDto.player().name()).thenApply(optional -> optional.map(nameAndId -> new Op((NameAndId)nameAndId, operatorDto.permissionLevel(), operatorDto.bypassesPlayerLimit())))).toList();
        Set set = Util.sequence(list).join().stream().flatMap(Optional::stream).collect(Collectors.toSet());
        Set set1 = api.operatorListService().getEntries().stream().filter(serverOpListEntry -> serverOpListEntry.getUser() != null).map(serverOpListEntry -> new Op((NameAndId)serverOpListEntry.getUser(), Optional.of(serverOpListEntry.permissions().level()), Optional.of(serverOpListEntry.getBypassesPlayerLimit()))).collect(Collectors.toSet());
        set1.stream().filter(op -> !set.contains(op)).forEach(op -> api.operatorListService().deop(op.user(), client));
        set.stream().filter(op -> !set1.contains(op)).forEach(op -> api.operatorListService().op(op.user(), op.permissionLevel(), op.bypassesPlayerLimit(), client));
        return OperatorService.get(api);
    }

    record Op(NameAndId user, Optional<PermissionLevel> permissionLevel, Optional<Boolean> bypassesPlayerLimit) {
    }

    public record OperatorDto(PlayerDto player, Optional<PermissionLevel> permissionLevel, Optional<Boolean> bypassesPlayerLimit) {
        public static final MapCodec<OperatorDto> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PlayerDto.CODEC.codec().fieldOf("player").forGetter(OperatorDto::player), (App)PermissionLevel.INT_CODEC.optionalFieldOf("permissionLevel").forGetter(OperatorDto::permissionLevel), (App)Codec.BOOL.optionalFieldOf("bypassesPlayerLimit").forGetter(OperatorDto::bypassesPlayerLimit)).apply((Applicative)instance, OperatorDto::new));

        public static OperatorDto from(ServerOpListEntry entry) {
            return new OperatorDto(PlayerDto.from(Objects.requireNonNull((NameAndId)entry.getUser())), Optional.of(entry.permissions().level()), Optional.of(entry.getBypassesPlayerLimit()));
        }
    }
}

