/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.security;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Set;
import net.minecraft.server.jsonrpc.security.SecurityConfig;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class AuthenticationHandler
extends ChannelDuplexHandler {
    private final Logger LOGGER = LogUtils.getLogger();
    private static final AttributeKey<Boolean> AUTHENTICATED_KEY = AttributeKey.valueOf((String)"authenticated");
    private static final AttributeKey<Boolean> ATTR_WEBSOCKET_ALLOWED = AttributeKey.valueOf((String)"websocket_auth_allowed");
    private static final String SUBPROTOCOL_VALUE = "minecraft-v1";
    private static final String SUBPROTOCOL_HEADER_PREFIX = "minecraft-v1,";
    public static final String BEARER_PREFIX = "Bearer ";
    private final SecurityConfig securityConfig;
    private final Set<String> allowedOrigins;

    public AuthenticationHandler(SecurityConfig securityConfig, String allowedOrigins) {
        this.securityConfig = securityConfig;
        this.allowedOrigins = Sets.newHashSet((Object[])allowedOrigins.split(","));
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Boolean _boolean;
        String clientIp = this.getClientIp(ctx);
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            SecurityCheckResult securityCheckResult = this.performSecurityChecks(httpRequest);
            if (!securityCheckResult.isAllowed()) {
                this.LOGGER.debug("Authentication rejected for connection with ip {}: {}", (Object)clientIp, (Object)securityCheckResult.getReason());
                ctx.channel().attr(AUTHENTICATED_KEY).set((Object)false);
                this.sendUnauthorizedResponse(ctx, securityCheckResult.getReason());
                return;
            }
            ctx.channel().attr(AUTHENTICATED_KEY).set((Object)true);
            if (securityCheckResult.isTokenSentInSecWebsocketProtocol()) {
                ctx.channel().attr(ATTR_WEBSOCKET_ALLOWED).set((Object)Boolean.TRUE);
            }
        }
        if (Boolean.TRUE.equals(_boolean = (Boolean)ctx.channel().attr(AUTHENTICATED_KEY).get())) {
            super.channelRead(ctx, msg);
        } else {
            this.LOGGER.debug("Dropping unauthenticated connection with ip {}", (Object)clientIp);
            ctx.close();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        HttpResponse httpResponse;
        if (msg instanceof HttpResponse && (httpResponse = (HttpResponse)msg).status().code() == HttpResponseStatus.SWITCHING_PROTOCOLS.code() && ctx.channel().attr(ATTR_WEBSOCKET_ALLOWED).get() != null && ((Boolean)ctx.channel().attr(ATTR_WEBSOCKET_ALLOWED).get()).equals(Boolean.TRUE)) {
            httpResponse.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)SUBPROTOCOL_VALUE);
        }
        super.write(ctx, msg, promise);
    }

    private SecurityCheckResult performSecurityChecks(HttpRequest request) {
        String string = this.parseTokenInAuthorizationHeader(request);
        if (string != null) {
            return this.isValidApiKey(string) ? SecurityCheckResult.allowed() : SecurityCheckResult.denied("Invalid API key");
        }
        String string1 = this.parseTokenInSecWebsocketProtocolHeader(request);
        if (string1 != null) {
            if (!this.isAllowedOriginHeader(request)) {
                return SecurityCheckResult.denied("Origin Not Allowed");
            }
            return this.isValidApiKey(string1) ? SecurityCheckResult.allowed(true) : SecurityCheckResult.denied("Invalid API key");
        }
        return SecurityCheckResult.denied("Missing API key");
    }

    private boolean isAllowedOriginHeader(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
        return string != null && !string.isEmpty() && this.allowedOrigins.contains(string);
    }

    private @Nullable String parseTokenInAuthorizationHeader(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.AUTHORIZATION);
        return string != null && string.startsWith(BEARER_PREFIX) ? string.substring(BEARER_PREFIX.length()).trim() : null;
    }

    private @Nullable String parseTokenInSecWebsocketProtocolHeader(HttpRequest request) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        return string != null && string.startsWith(SUBPROTOCOL_HEADER_PREFIX) ? string.substring(SUBPROTOCOL_HEADER_PREFIX.length()).trim() : null;
    }

    public boolean isValidApiKey(String key) {
        if (key.isEmpty()) {
            return false;
        }
        byte[] bytes = key.getBytes(StandardCharsets.UTF_8);
        byte[] bytes1 = this.securityConfig.secretKey().getBytes(StandardCharsets.UTF_8);
        return MessageDigest.isEqual(bytes, bytes1);
    }

    private String getClientIp(ChannelHandlerContext ctx) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetSocketAddress.getAddress().getHostAddress();
    }

    private void sendUnauthorizedResponse(ChannelHandlerContext ctx, String message) {
        String string = "{\"error\":\"Unauthorized\",\"message\":\"" + message + "\"}";
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED, Unpooled.wrappedBuffer((byte[])bytes));
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/json");
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bytes.length);
        defaultFullHttpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        ctx.writeAndFlush((Object)defaultFullHttpResponse).addListener(future -> ctx.close());
    }

    static class SecurityCheckResult {
        private final boolean allowed;
        private final String reason;
        private final boolean tokenSentInSecWebsocketProtocol;

        private SecurityCheckResult(boolean allowed, String reason, boolean tokenSentInSecWebsocketProtocol) {
            this.allowed = allowed;
            this.reason = reason;
            this.tokenSentInSecWebsocketProtocol = tokenSentInSecWebsocketProtocol;
        }

        public static SecurityCheckResult allowed() {
            return new SecurityCheckResult(true, null, false);
        }

        public static SecurityCheckResult allowed(boolean tokenSentInSecWebsocketProtocol) {
            return new SecurityCheckResult(true, null, tokenSentInSecWebsocketProtocol);
        }

        public static SecurityCheckResult denied(String reason) {
            return new SecurityCheckResult(false, reason, false);
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean isTokenSentInSecWebsocketProtocol() {
            return this.tokenSentInSecWebsocketProtocol;
        }
    }
}

