/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Consumer;
import net.minecraft.world.level.ChunkPos;

public interface ChunkTrackingView {
    public static final ChunkTrackingView EMPTY = new ChunkTrackingView(){

        @Override
        public boolean contains(int x, int z, boolean includeOuterChunksAdjacentToViewBorder) {
            return false;
        }

        @Override
        public void forEach(Consumer<ChunkPos> action) {
        }
    };

    public static ChunkTrackingView of(ChunkPos center, int viewDistance) {
        return new Positioned(center, viewDistance);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public static void difference(ChunkTrackingView oldChunkTrackingView, ChunkTrackingView newChunkTrackingView, Consumer<ChunkPos> chunkMarker, Consumer<ChunkPos> chunkDropper) {
        Positioned positioned1;
        Positioned positioned;
        block7: {
            block6: {
                if (oldChunkTrackingView.equals(newChunkTrackingView)) return;
                if (!(oldChunkTrackingView instanceof Positioned)) break block6;
                positioned = (Positioned)oldChunkTrackingView;
                if (newChunkTrackingView instanceof Positioned && positioned.squareIntersects(positioned1 = (Positioned)newChunkTrackingView)) break block7;
            }
            oldChunkTrackingView.forEach(chunkDropper);
            newChunkTrackingView.forEach(chunkMarker);
            return;
        }
        int min = Math.min(positioned.minX(), positioned1.minX());
        int min1 = Math.min(positioned.minZ(), positioned1.minZ());
        int max = Math.max(positioned.maxX(), positioned1.maxX());
        int max1 = Math.max(positioned.maxZ(), positioned1.maxZ());
        int i = min;
        while (i <= max) {
            for (int i1 = min1; i1 <= max1; ++i1) {
                boolean flag1;
                boolean flag = positioned.contains(i, i1);
                if (flag == (flag1 = positioned1.contains(i, i1))) continue;
                if (flag1) {
                    chunkMarker.accept(new ChunkPos(i, i1));
                    continue;
                }
                chunkDropper.accept(new ChunkPos(i, i1));
            }
            ++i;
        }
    }

    default public boolean contains(ChunkPos chunkPos) {
        return this.contains(chunkPos.x, chunkPos.z);
    }

    default public boolean contains(int x, int z) {
        return this.contains(x, z, true);
    }

    public boolean contains(int var1, int var2, boolean var3);

    public void forEach(Consumer<ChunkPos> var1);

    default public boolean isInViewDistance(int x, int z) {
        return this.contains(x, z, false);
    }

    public static boolean isInViewDistance(int centerX, int centerZ, int viewDistance, int x, int z) {
        return ChunkTrackingView.isWithinDistance(centerX, centerZ, viewDistance, x, z, false);
    }

    public static boolean isWithinDistance(int centerX, int centerZ, int viewDistance, int x, int z, boolean includeOuterChunksAdjacentToViewBorder) {
        int i = includeOuterChunksAdjacentToViewBorder ? 2 : 1;
        long l = Math.max(0, Math.abs(x - centerX) - i);
        long l1 = Math.max(0, Math.abs(z - centerZ) - i);
        long l2 = l * l + l1 * l1;
        int i1 = viewDistance * viewDistance;
        return l2 < (long)i1;
    }

    public record Positioned(ChunkPos center, int viewDistance) implements ChunkTrackingView
    {
        int minX() {
            return this.center.x - this.viewDistance - 1;
        }

        int minZ() {
            return this.center.z - this.viewDistance - 1;
        }

        int maxX() {
            return this.center.x + this.viewDistance + 1;
        }

        int maxZ() {
            return this.center.z + this.viewDistance + 1;
        }

        @VisibleForTesting
        protected boolean squareIntersects(Positioned other) {
            return this.minX() <= other.maxX() && this.maxX() >= other.minX() && this.minZ() <= other.maxZ() && this.maxZ() >= other.minZ();
        }

        @Override
        public boolean contains(int x, int z, boolean includeOuterChunksAdjacentToViewBorder) {
            return ChunkTrackingView.isWithinDistance(this.center.x, this.center.z, this.viewDistance, x, z, includeOuterChunksAdjacentToViewBorder);
        }

        @Override
        public void forEach(Consumer<ChunkPos> action) {
            for (int i = this.minX(); i <= this.maxX(); ++i) {
                for (int i1 = this.minZ(); i1 <= this.maxZ(); ++i1) {
                    if (!this.contains(i, i1)) continue;
                    action.accept(new ChunkPos(i, i1));
                }
            }
        }
    }
}

