/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.network.FilteredText;

public record Filterable<T>(T raw, Optional<T> filtered) {
    public static <T> Codec<Filterable<T>> codec(Codec<T> codec) {
        Codec codec1 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("raw").forGetter(Filterable::raw), (App)codec.optionalFieldOf("filtered").forGetter(Filterable::filtered)).apply((Applicative)instance, Filterable::new));
        Codec codec2 = codec.xmap(Filterable::passThrough, Filterable::raw);
        return Codec.withAlternative((Codec)codec1, (Codec)codec2);
    }

    public static <B extends ByteBuf, T> StreamCodec<B, Filterable<T>> streamCodec(StreamCodec<B, T> codec) {
        return StreamCodec.composite(codec, Filterable::raw, codec.apply(ByteBufCodecs::optional), Filterable::filtered, Filterable::new);
    }

    public static <T> Filterable<T> passThrough(T value) {
        return new Filterable<T>(value, Optional.empty());
    }

    public static Filterable<String> from(FilteredText filteredText) {
        return new Filterable<String>(filteredText.raw(), filteredText.isFiltered() ? Optional.of(filteredText.filteredOrEmpty()) : Optional.empty());
    }

    public T get(boolean filtered) {
        return filtered ? this.filtered.orElse(this.raw) : this.raw;
    }

    public <U> Filterable<U> map(Function<T, U> mappingFunction) {
        return new Filterable<U>(mappingFunction.apply(this.raw), this.filtered.map(mappingFunction));
    }

    public <U> Optional<Filterable<U>> resolve(Function<T, Optional<U>> resolver) {
        Optional<U> optional = resolver.apply(this.raw);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        if (this.filtered.isPresent()) {
            Optional<U> optional1 = resolver.apply(this.filtered.get());
            return optional1.isEmpty() ? Optional.empty() : Optional.of(new Filterable<U>(optional.get(), optional1));
        }
        return Optional.of(new Filterable<U>(optional.get(), Optional.empty()));
    }
}

