/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.proxy.VelocityProxy;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.configuration.GlobalConfiguration;
import io.papermc.paper.connection.PaperPlayerLoginConnection;
import io.papermc.paper.connection.PlayerConnection;
import io.papermc.paper.connection.PlayerLoginConnection;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundHelloPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ClientboundLoginFinishedPacket;
import net.minecraft.network.protocol.login.ServerLoginPacketListener;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.network.protocol.login.ServerboundKeyPacket;
import net.minecraft.network.protocol.login.ServerboundLoginAcknowledgedPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerHandshakePacketListenerImpl;
import net.minecraft.server.notifications.ServerActivityMonitor;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Crypt;
import net.minecraft.util.CryptException;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringUtil;
import org.apache.commons.lang3.Validate;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.event.CraftEventFactory;
import org.bukkit.craftbukkit.util.Waitable;
import org.bukkit.event.Event;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerPreLoginEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ServerLoginPacketListenerImpl
implements ServerLoginPacketListener,
TickablePacketListener {
    private static final AtomicInteger UNIQUE_THREAD_ID = new AtomicInteger(0);
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService authenticatorPool = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("User Authenticator #%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    private static final int MAX_TICKS_BEFORE_LOGIN = 600;
    private final byte[] challenge;
    final MinecraftServer server;
    public final Connection connection;
    final ServerActivityMonitor serverActivityMonitor;
    public volatile State state = State.HELLO;
    private int tick;
    public @Nullable String requestedUsername;
    public @Nullable GameProfile authenticatedProfile;
    private final String serverId = "";
    public final boolean transferred;
    public boolean iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation = false;
    private int velocityLoginMessageId = -1;
    public @Nullable UUID requestedUuid;
    private final PaperPlayerLoginConnection paperLoginConnection;
    private volatile boolean disconnecting = false;

    public ServerLoginPacketListenerImpl(MinecraftServer server, Connection connection, boolean transferred) {
        this.server = server;
        this.connection = connection;
        this.serverActivityMonitor = this.server.getServerActivityMonitor();
        this.challenge = Ints.toByteArray((int)RandomSource.create().nextInt());
        this.transferred = transferred;
        this.paperLoginConnection = new PaperPlayerLoginConnection(this);
    }

    @Override
    public void tick() {
        if (this.disconnecting) {
            return;
        }
        if (this.paperLoginConnection.isAwaitingCookies()) {
            this.tickTimeout();
            return;
        }
        if (this.state == State.VERIFYING) {
            this.verifyLoginAndFinishConnectionSetup(Objects.requireNonNull(this.authenticatedProfile));
        }
        if (this.state == State.WAITING_FOR_DUPE_DISCONNECT && !this.isPlayerAlreadyInWorld(Objects.requireNonNull(this.authenticatedProfile))) {
            this.finishLoginAndWaitForClient(this.authenticatedProfile);
        }
        this.tickTimeout();
    }

    public void tickTimeout() {
        if (this.tick++ == 600) {
            this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.slow_login"));
        }
    }

    @Deprecated
    public void disconnect(String reason) {
        this.disconnect(PaperAdventure.asVanilla((Component)LegacyComponentSerializer.legacySection().deserialize(reason)));
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    public void disconnect(net.minecraft.network.chat.Component reason) {
        try {
            LOGGER.info("Disconnecting {}: {}", (Object)this.getUserName(), (Object)reason.getString());
            this.connection.send(new ClientboundLoginDisconnectPacket(reason));
            this.connection.disconnect(reason);
            this.disconnecting = true;
        }
        catch (Exception var3) {
            LOGGER.error("Error whilst disconnecting player", (Throwable)var3);
        }
    }

    private boolean isPlayerAlreadyInWorld(GameProfile profile) {
        return this.server.getPlayerList().getPlayer(profile.id()) != null;
    }

    @Override
    public void onDisconnect(DisconnectionDetails details) {
        LOGGER.info("{} lost connection: {}", (Object)this.getUserName(), (Object)details.reason().getString());
    }

    public String getUserName() {
        String loggableAddress = this.connection.getLoggableAddress(this.server.logIPs());
        return this.requestedUsername != null ? this.requestedUsername + " (" + loggableAddress + ")" : loggableAddress;
    }

    @Override
    public void handleHello(ServerboundHelloPacket packet) {
        Validate.validState((this.state == State.HELLO ? 1 : 0) != 0, (String)"Unexpected hello packet", (Object[])new Object[0]);
        if (GlobalConfiguration.get().proxies.isProxyOnlineMode() && GlobalConfiguration.get().unsupportedSettings.performUsernameValidation && !this.iKnowThisMayNotBeTheBestIdeaButPleaseDisableUsernameValidation) {
            Validate.validState((boolean)StringUtil.isReasonablePlayerName(packet.name()), (String)"Invalid characters in username", (Object[])new Object[0]);
        }
        this.requestedUuid = packet.profileId();
        this.requestedUsername = packet.name();
        GameProfile singleplayerProfile = this.server.getSingleplayerProfile();
        if (singleplayerProfile != null && this.requestedUsername.equalsIgnoreCase(singleplayerProfile.name())) {
            this.startClientVerification(singleplayerProfile);
        } else if (this.server.usesAuthentication() && !this.connection.isMemoryConnection()) {
            this.state = State.KEY;
            this.connection.send(new ClientboundHelloPacket("", this.server.getKeyPair().getPublic().getEncoded(), this.challenge, true));
        } else {
            if (GlobalConfiguration.get().proxies.velocity.enabled) {
                this.velocityLoginMessageId = ThreadLocalRandom.current().nextInt();
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeByte(4);
                ClientboundCustomQueryPacket packet1 = new ClientboundCustomQueryPacket(this.velocityLoginMessageId, new ClientboundCustomQueryPacket.PlayerInfoChannelPayload(VelocityProxy.PLAYER_INFO_CHANNEL, buf));
                this.connection.send(packet1);
                return;
            }
            authenticatorPool.execute(() -> {
                try {
                    GameProfile gameprofile = this.createOfflineProfile(this.requestedUsername);
                    gameprofile = this.callPlayerPreLoginEvents(gameprofile);
                    LOGGER.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                    this.startClientVerification(gameprofile);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.server.server.getLogger().log(Level.WARNING, "Exception verifying " + this.requestedUsername, ex);
                }
            });
        }
    }

    void startClientVerification(GameProfile authenticatedProfile) {
        this.authenticatedProfile = authenticatedProfile;
        this.state = State.VERIFYING;
    }

    private void verifyLoginAndFinishConnectionSetup(GameProfile profile) {
        PlayerList playerList = this.server.getPlayerList();
        net.minecraft.network.chat.Component component = CraftEventFactory.handleLoginResult(playerList.canPlayerLogin(this.connection.getRemoteAddress(), new NameAndId(profile)), (PlayerConnection)this.paperLoginConnection, this.connection, profile, this.server, true);
        if (component != null) {
            this.disconnect(component);
        } else {
            boolean flag;
            if (this.server.getCompressionThreshold() >= 0 && !this.connection.isMemoryConnection()) {
                this.connection.send(new ClientboundLoginCompressionPacket(this.server.getCompressionThreshold()), PacketSendListener.thenRun(() -> this.connection.setupCompression(this.server.getCompressionThreshold(), true)));
            }
            if (flag = playerList.disconnectAllPlayersWithProfile(profile)) {
                this.state = State.WAITING_FOR_DUPE_DISCONNECT;
            } else {
                this.finishLoginAndWaitForClient(profile);
            }
        }
    }

    private void finishLoginAndWaitForClient(GameProfile profile) {
        this.state = State.PROTOCOL_SWITCHING;
        this.connection.send(new ClientboundLoginFinishedPacket(profile));
        this.server.services().paper().filledProfileCache().add(profile);
    }

    @Override
    public void handleKey(ServerboundKeyPacket packet) {
        String string;
        Validate.validState((this.state == State.KEY ? 1 : 0) != 0, (String)"Unexpected key packet", (Object[])new Object[0]);
        try {
            PrivateKey _private = this.server.getKeyPair().getPrivate();
            if (!packet.isChallengeValid(this.challenge, _private)) {
                throw new IllegalStateException("Protocol error");
            }
            SecretKey secretKey = packet.getSecretKey(_private);
            string = new BigInteger(Crypt.digestData("", this.server.getKeyPair().getPublic(), secretKey)).toString(16);
            this.state = State.AUTHENTICATING;
            this.connection.setEncryptionKey(secretKey);
        }
        catch (CryptException var7) {
            throw new IllegalStateException("Protocol error", var7);
        }
        authenticatorPool.execute(new Runnable(){

            @Override
            public void run() {
                String string1 = Objects.requireNonNull(ServerLoginPacketListenerImpl.this.requestedUsername, "Player name not initialized");
                try {
                    ProfileResult profileResult = ServerLoginPacketListenerImpl.this.server.services().sessionService().hasJoinedServer(string1, string, this.getAddress());
                    if (profileResult != null) {
                        GameProfile gameProfile = profileResult.profile();
                        if (!ServerLoginPacketListenerImpl.this.connection.isConnected()) {
                            return;
                        }
                        gameProfile = ServerLoginPacketListenerImpl.this.callPlayerPreLoginEvents(gameProfile);
                        LOGGER.info("UUID of player {} is {}", (Object)gameProfile.name(), (Object)gameProfile.id());
                        ServerLoginPacketListenerImpl.this.serverActivityMonitor.reportLoginActivity();
                        ServerLoginPacketListenerImpl.this.startClientVerification(gameProfile);
                    } else if (ServerLoginPacketListenerImpl.this.server.isSingleplayer()) {
                        LOGGER.warn("Failed to verify username but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.startClientVerification(ServerLoginPacketListenerImpl.this.createOfflineProfile(string1));
                    } else {
                        ServerLoginPacketListenerImpl.this.disconnect(net.minecraft.network.chat.Component.translatable("multiplayer.disconnect.unverified_username"));
                        LOGGER.error("Username '{}' tried to join with an invalid session", (Object)string1);
                    }
                }
                catch (AuthenticationUnavailableException var4) {
                    if (ServerLoginPacketListenerImpl.this.server.isSingleplayer()) {
                        LOGGER.warn("Authentication servers are down but will let them in anyway!");
                        ServerLoginPacketListenerImpl.this.startClientVerification(ServerLoginPacketListenerImpl.this.createOfflineProfile(string1));
                    } else {
                        ServerLoginPacketListenerImpl.this.disconnect(PaperAdventure.asVanilla(GlobalConfiguration.get().messages.kick.authenticationServersDown));
                        LOGGER.error("Couldn't verify username because servers are unavailable");
                    }
                }
                catch (Exception ex) {
                    ServerLoginPacketListenerImpl.this.disconnect("Failed to verify username!");
                    LOGGER.warn("Exception verifying {}", (Object)string1, (Object)ex);
                }
            }

            private @Nullable InetAddress getAddress() {
                SocketAddress remoteAddress = ServerLoginPacketListenerImpl.this.connection.getRemoteAddress();
                return ServerLoginPacketListenerImpl.this.server.getPreventProxyConnections() && remoteAddress instanceof InetSocketAddress ? ((InetSocketAddress)remoteAddress).getAddress() : null;
            }
        });
    }

    private GameProfile callPlayerPreLoginEvents(GameProfile gameprofile) throws Exception {
        if (this.velocityLoginMessageId == -1 && GlobalConfiguration.get().proxies.velocity.enabled) {
            this.disconnect("This server requires you to connect with Velocity.");
            return gameprofile;
        }
        String playerName = gameprofile.name();
        InetAddress address = ((InetSocketAddress)this.connection.getRemoteAddress()).getAddress();
        UUID uniqueId = gameprofile.id();
        final CraftServer server = this.server.server;
        InetAddress rawAddress = ((InetSocketAddress)this.connection.channel.remoteAddress()).getAddress();
        PlayerProfile profile = CraftPlayerProfile.asBukkitCopy(gameprofile);
        AsyncPlayerPreLoginEvent asyncEvent = new AsyncPlayerPreLoginEvent(playerName, address, rawAddress, uniqueId, this.transferred, profile, this.connection.hostname, (PlayerLoginConnection)this.paperLoginConnection);
        server.getPluginManager().callEvent((Event)asyncEvent);
        profile = asyncEvent.getPlayerProfile();
        profile.complete(true);
        gameprofile = CraftPlayerProfile.asAuthlibCopy(profile);
        playerName = gameprofile.name();
        uniqueId = gameprofile.id();
        if (PlayerPreLoginEvent.getHandlerList().getRegisteredListeners().length != 0) {
            final PlayerPreLoginEvent event = new PlayerPreLoginEvent(playerName, address, uniqueId);
            if (asyncEvent.getResult() != PlayerPreLoginEvent.Result.ALLOWED) {
                event.disallow(asyncEvent.getResult(), asyncEvent.kickMessage());
            }
            Waitable<PlayerPreLoginEvent.Result> waitable = new Waitable<PlayerPreLoginEvent.Result>(this){

                @Override
                protected PlayerPreLoginEvent.Result evaluate() {
                    server.getPluginManager().callEvent((Event)event);
                    return event.getResult();
                }
            };
            this.server.processQueue.add(waitable);
            if (waitable.get() != PlayerPreLoginEvent.Result.ALLOWED) {
                this.disconnect(PaperAdventure.asVanilla(event.kickMessage()));
            }
        } else if (asyncEvent.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            this.disconnect(PaperAdventure.asVanilla(asyncEvent.kickMessage()));
        }
        return gameprofile;
    }

    @Override
    public void handleCustomQueryPacket(ServerboundCustomQueryAnswerPacket packet) {
        try {
            this.handleCustomQueryPacket0(packet);
        }
        catch (Throwable throwable) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.payload();
            if (payload != null) {
                payload.buffer.release();
            }
            throw throwable;
        }
        ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.payload();
        if (payload != null) {
            payload.buffer.release();
        }
    }

    private void handleCustomQueryPacket0(ServerboundCustomQueryAnswerPacket packet) {
        if (GlobalConfiguration.get().proxies.velocity.enabled && packet.transactionId() == this.velocityLoginMessageId) {
            ServerboundCustomQueryAnswerPacket.QueryAnswerPayload payload = (ServerboundCustomQueryAnswerPacket.QueryAnswerPayload)packet.payload();
            if (payload == null) {
                this.disconnect("This server requires you to connect with Velocity.");
                return;
            }
            FriendlyByteBuf buf = payload.buffer;
            if (!VelocityProxy.checkIntegrity(buf)) {
                this.disconnect("Unable to verify player details");
                return;
            }
            int version = buf.readVarInt();
            if (version > 4) {
                throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted upto 4");
            }
            SocketAddress listening = this.connection.getRemoteAddress();
            int port = 0;
            if (listening instanceof InetSocketAddress) {
                port = ((InetSocketAddress)listening).getPort();
            }
            this.connection.address = new InetSocketAddress(VelocityProxy.readAddress(buf), port);
            this.authenticatedProfile = VelocityProxy.createProfile(buf);
            authenticatorPool.execute(() -> {
                try {
                    GameProfile gameprofile = this.callPlayerPreLoginEvents(this.authenticatedProfile);
                    LOGGER.info("UUID of player {} is {}", (Object)gameprofile.name(), (Object)gameprofile.id());
                    this.startClientVerification(gameprofile);
                }
                catch (Exception ex) {
                    this.disconnect("Failed to verify username!");
                    this.server.server.getLogger().log(Level.WARNING, "Exception verifying " + this.authenticatedProfile.name(), ex);
                }
            });
            return;
        }
        this.disconnect(ServerCommonPacketListenerImpl.DISCONNECT_UNEXPECTED_QUERY);
    }

    @Override
    public void handleLoginAcknowledgement(ServerboundLoginAcknowledgedPacket packet) {
        PacketUtils.ensureRunningOnSameThread(packet, this, this.server.packetProcessor());
        Validate.validState((this.state == State.PROTOCOL_SWITCHING ? 1 : 0) != 0, (String)"Unexpected login acknowledgement packet", (Object[])new Object[0]);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
        CommonListenerCookie commonListenerCookie = CommonListenerCookie.createInitial(Objects.requireNonNull(this.authenticatedProfile), this.transferred);
        ServerConfigurationPacketListenerImpl serverConfigurationPacketListenerImpl = new ServerConfigurationPacketListenerImpl(this.server, this.connection, commonListenerCookie);
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, serverConfigurationPacketListenerImpl);
        serverConfigurationPacketListenerImpl.startConfiguration();
        this.state = State.ACCEPTED;
    }

    @Override
    public void fillListenerSpecificCrashDetails(CrashReport crashReport, CrashReportCategory category) {
        category.setDetail("Login phase", () -> this.state.toString());
    }

    @Override
    public void handleCookieResponse(ServerboundCookieResponsePacket packet) {
        if (this.paperLoginConnection.handleCookieResponse(packet)) {
            return;
        }
        this.disconnect(ServerCommonPacketListenerImpl.DISCONNECT_UNEXPECTED_QUERY);
    }

    protected GameProfile createOfflineProfile(String s) {
        UUID uuid = this.connection.spoofedUUID != null ? this.connection.spoofedUUID : UUIDUtil.createOfflinePlayerUUID(s);
        ImmutableMultimap.Builder props = ImmutableMultimap.builder();
        if (this.connection.spoofedProfile != null) {
            for (Property property : this.connection.spoofedProfile) {
                if (!ServerHandshakePacketListenerImpl.PROP_PATTERN.matcher(property.name()).matches()) continue;
                props.put((Object)property.name(), (Object)property);
            }
        }
        return new GameProfile(uuid, s, new PropertyMap((Multimap)props.build()));
    }

    public static enum State {
        HELLO,
        KEY,
        AUTHENTICATING,
        NEGOTIATING,
        VERIFYING,
        WAITING_FOR_DUPE_DISCONNECT,
        PROTOCOL_SWITCHING,
        ACCEPTED;

    }
}

