/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.util.FileUtil;
import net.minecraft.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class PathPackResources
extends AbstractPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final Path root;

    public PathPackResources(PackLocationInfo location, Path root) {
        super(location);
        this.root = root;
    }

    @Override
    public @Nullable IoSupplier<InputStream> getRootResource(String ... elements) {
        FileUtil.validatePath(elements);
        Path path = FileUtil.resolvePath(this.root, List.of(elements));
        return Files.exists(path, new LinkOption[0]) ? IoSupplier.create(path) : null;
    }

    public static boolean validatePath(Path path) {
        if (!SharedConstants.DEBUG_VALIDATE_RESOURCE_PATH_CASE) {
            return true;
        }
        if (path.getFileSystem() != FileSystems.getDefault()) {
            return true;
        }
        try {
            return path.toRealPath(new LinkOption[0]).endsWith(path);
        }
        catch (IOException var2) {
            LOGGER.warn("Failed to resolve real path for {}", (Object)path, (Object)var2);
            return false;
        }
    }

    @Override
    public @Nullable IoSupplier<InputStream> getResource(PackType packType, Identifier location) {
        Path path = this.root.resolve(packType.getDirectory()).resolve(location.getNamespace());
        return PathPackResources.getResource(location, path);
    }

    public static @Nullable IoSupplier<InputStream> getResource(Identifier location, Path path) {
        return (IoSupplier)FileUtil.decomposePath(location.getPath()).mapOrElse(elements -> {
            Path path1 = FileUtil.resolvePath(path, elements);
            return PathPackResources.returnFileIfExists(path1);
        }, error -> {
            LOGGER.error("Invalid path {}: {}", (Object)location, (Object)error.message());
            return null;
        });
    }

    private static @Nullable IoSupplier<InputStream> returnFileIfExists(Path path) {
        return Files.exists(path, new LinkOption[0]) && PathPackResources.validatePath(path) ? IoSupplier.create(path) : null;
    }

    @Override
    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        FileUtil.decomposePath(path).ifSuccess(tets -> {
            Path path1 = this.root.resolve(packType.getDirectory()).resolve(namespace);
            PathPackResources.listPath(namespace, path1, tets, resourceOutput);
        }).ifError(error -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)error.message()));
    }

    public static void listPath(String namespace, Path namespacePath, List<String> decomposedPath, PackResources.ResourceOutput resourceOutput) {
        Path path = FileUtil.resolvePath(namespacePath, decomposedPath);
        try (Stream<Path> stream2 = Files.find(path, Integer.MAX_VALUE, PathPackResources::isRegularFile, new FileVisitOption[0]);){
            stream2.forEach(path1 -> {
                String string = PATH_JOINER.join((Iterable)namespacePath.relativize((Path)path1));
                Identifier identifier = Identifier.tryBuild(namespace, string);
                if (identifier == null) {
                    Util.logAndPauseIfInIde(String.format(Locale.ROOT, "Invalid path in pack: %s:%s, ignoring", namespace, string));
                } else {
                    resourceOutput.accept(identifier, IoSupplier.create(path1));
                }
            });
        }
        catch (NoSuchFileException | NotDirectoryException stream2) {
        }
        catch (IOException var11) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)var11);
        }
    }

    private static boolean isRegularFile(Path path, BasicFileAttributes attributes) {
        return !SharedConstants.IS_RUNNING_IN_IDE ? attributes.isRegularFile() : attributes.isRegularFile() && !StringUtils.equalsIgnoreCase((CharSequence)path.getFileName().toString(), (CharSequence)".ds_store");
    }

    @Override
    public Set<String> getNamespaces(PackType type) {
        HashSet set = Sets.newHashSet();
        Path path = this.root.resolve(type.getDirectory());
        try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(path);){
            for (Path path1 : directoryStream2) {
                String string = path1.getFileName().toString();
                if (!Files.isDirectory(path1, new LinkOption[0])) {
                    LOGGER.error("Invalid directory entry: {} in {}.", new Object[]{string, this.root, new NotDirectoryException(string)});
                    continue;
                }
                if (Identifier.isValidNamespace(string)) {
                    set.add(string);
                    continue;
                }
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in pack {}, ignoring", (Object)string, (Object)this.root);
            }
        }
        catch (NoSuchFileException | NotDirectoryException directoryStream2) {
        }
        catch (IOException var11) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)var11);
        }
        return set;
    }

    @Override
    public void close() {
    }

    public static class PathResourcesSupplier
    implements Pack.ResourcesSupplier {
        private final Path content;

        public PathResourcesSupplier(Path content) {
            this.content = content;
        }

        @Override
        public PackResources openPrimary(PackLocationInfo location) {
            return new PathPackResources(location, this.content);
        }

        @Override
        public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
            PackResources packResources = this.openPrimary(location);
            List<String> list = metadata.overlays();
            if (list.isEmpty()) {
                return packResources;
            }
            ArrayList<PackResources> list1 = new ArrayList<PackResources>(list.size());
            for (String string : list) {
                Path path = this.content.resolve(string);
                list1.add(new PathPackResources(location, path));
            }
            return new CompositePackResources(packResources, list1);
        }
    }
}

