/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.permissions;

import net.minecraft.server.permissions.Permission;
import net.minecraft.server.permissions.PermissionLevel;
import net.minecraft.server.permissions.PermissionSet;
import net.minecraft.server.permissions.Permissions;

public interface LevelBasedPermissionSet
extends PermissionSet {
    @Deprecated
    public static final LevelBasedPermissionSet ALL = LevelBasedPermissionSet.create(PermissionLevel.ALL);
    public static final LevelBasedPermissionSet MODERATOR = LevelBasedPermissionSet.create(PermissionLevel.MODERATORS);
    public static final LevelBasedPermissionSet GAMEMASTER = LevelBasedPermissionSet.create(PermissionLevel.GAMEMASTERS);
    public static final LevelBasedPermissionSet ADMIN = LevelBasedPermissionSet.create(PermissionLevel.ADMINS);
    public static final LevelBasedPermissionSet OWNER = LevelBasedPermissionSet.create(PermissionLevel.OWNERS);

    public PermissionLevel level();

    @Override
    default public boolean hasPermission(Permission permission) {
        boolean bl;
        if (permission instanceof Permission.HasCommandLevel) {
            Permission.HasCommandLevel hasCommandLevel = (Permission.HasCommandLevel)permission;
            bl = this.level().isEqualOrHigherThan(hasCommandLevel.level());
        } else {
            bl = permission.equals(Permissions.COMMANDS_ENTITY_SELECTORS) && this.level().isEqualOrHigherThan(PermissionLevel.GAMEMASTERS);
        }
        return bl;
    }

    @Override
    default public PermissionSet union(PermissionSet permissions) {
        if (permissions instanceof LevelBasedPermissionSet) {
            LevelBasedPermissionSet levelBasedPermissionSet = (LevelBasedPermissionSet)permissions;
            return this.level().isEqualOrHigherThan(levelBasedPermissionSet.level()) ? levelBasedPermissionSet : this;
        }
        return PermissionSet.super.union(permissions);
    }

    public static LevelBasedPermissionSet forLevel(PermissionLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case PermissionLevel.ALL -> ALL;
            case PermissionLevel.MODERATORS -> MODERATOR;
            case PermissionLevel.GAMEMASTERS -> GAMEMASTER;
            case PermissionLevel.ADMINS -> ADMIN;
            case PermissionLevel.OWNERS -> OWNER;
        };
    }

    private static LevelBasedPermissionSet create(final PermissionLevel level) {
        return new LevelBasedPermissionSet(){

            @Override
            public PermissionLevel level() {
                return level;
            }

            public String toString() {
                return "permission level: " + level.name();
            }
        };
    }
}

