/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.permissions;

import com.mojang.brigadier.tree.CommandNode;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.permissions.PermissionCheck;
import net.minecraft.server.permissions.PermissionSetSupplier;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;

public record PermissionProviderCheck<T extends PermissionSetSupplier>(PermissionCheck test, AtomicReference<CommandNode<CommandSourceStack>> vanillaNode) implements Predicate<T>
{
    public PermissionProviderCheck(PermissionCheck test) {
        this(test, new AtomicReference<Object>(null));
    }

    @Override
    public boolean test(T permissionsSupplier) {
        CommandNode<CommandSourceStack> currentCommand = this.vanillaNode.get();
        if (currentCommand != null && permissionsSupplier instanceof CommandSourceStack) {
            CommandSourceStack commandSourceStack = (CommandSourceStack)permissionsSupplier;
            PermissionCheck permissionCheck = this.test;
            if (permissionCheck instanceof PermissionCheck.Require) {
                PermissionCheck.Require req = (PermissionCheck.Require)permissionCheck;
                return commandSourceStack.hasPermission(req.permission(), VanillaCommandWrapper.getPermission(currentCommand));
            }
        }
        return this.test.check(permissionsSupplier.permissions());
    }
}

