/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Util;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class StoredUserList<K, V extends StoredUserEntry<K>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private final Map<String, V> map = Maps.newConcurrentMap();
    protected final NotificationService notificationService;

    public StoredUserList(File file, NotificationService notificationService) {
        this.file = file;
        this.notificationService = notificationService;
    }

    public File getFile() {
        return this.file;
    }

    public boolean add(V entry) {
        String keyForUser = this.getKeyForUser(((StoredUserEntry)entry).getUser());
        StoredUserEntry storedUserEntry = (StoredUserEntry)this.map.get(keyForUser);
        if (entry.equals(storedUserEntry)) {
            return false;
        }
        this.map.put(keyForUser, entry);
        try {
            this.save();
        }
        catch (IOException var5) {
            LOGGER.warn("Could not save the list after adding a user.", (Throwable)var5);
        }
        return true;
    }

    public @Nullable V get(K user) {
        return (V)this.map.computeIfPresent(this.getKeyForUser(user), (key, value) -> value.hasExpired() ? null : value);
    }

    public boolean remove(K user) {
        StoredUserEntry storedUserEntry = (StoredUserEntry)this.map.remove(this.getKeyForUser(user));
        if (storedUserEntry == null) {
            return false;
        }
        try {
            this.save();
        }
        catch (IOException var4) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)var4);
        }
        return true;
    }

    public boolean remove(StoredUserEntry<K> entry) {
        return this.remove(Objects.requireNonNull(entry.getUser()));
    }

    public void clear() {
        this.map.clear();
        try {
            this.save();
        }
        catch (IOException var2) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)var2);
        }
    }

    public String[] getUserList() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    protected String getKeyForUser(K user) {
        return user.toString();
    }

    protected boolean contains(K entry) {
        this.removeExpired();
        return this.map.containsKey(this.getKeyForUser(entry));
    }

    private void removeExpired() {
        this.map.values().removeIf(StoredUserEntry::hasExpired);
    }

    protected abstract StoredUserEntry<K> createEntry(JsonObject var1);

    public Collection<V> getEntries() {
        return this.map.values();
    }

    public void save() throws IOException {
        this.removeExpired();
        JsonArray jsonArray = new JsonArray();
        this.map.values().stream().map(storedEntry -> Util.make(new JsonObject(), storedEntry::serialize)).forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
        try (BufferedWriter writer = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonArray, GSON.newJsonWriter((Writer)writer));
        }
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            try (BufferedReader reader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
                this.map.clear();
                JsonArray jsonArray = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
                if (jsonArray == null) {
                    return;
                }
                for (JsonElement jsonElement : jsonArray) {
                    JsonObject jsonObject = GsonHelper.convertToJsonObject(jsonElement, "entry");
                    StoredUserEntry<K> storedUserEntry = this.createEntry(jsonObject);
                    if (storedUserEntry.getUser() == null) continue;
                    this.map.put(this.getKeyForUser(storedUserEntry.getUser()), storedUserEntry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                File backup = new File(String.valueOf(this.file) + ".backup");
                LOGGER.warn("Unable to read file {}, backing it up to {} and creating new copy.", new Object[]{this.file, backup, ex});
                this.file.renameTo(backup);
                this.file.delete();
            }
        }
    }
}

