/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon;

import java.net.SocketAddress;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.command.CraftRemoteConsoleCommandSender;

public class RconConsoleSource
implements CommandSource {
    private static final String RCON = "Rcon";
    private static final Component RCON_COMPONENT = Component.literal("Rcon");
    private final StringBuffer buffer = new StringBuffer();
    private final MinecraftServer server;
    public final SocketAddress socketAddress;
    private final CraftRemoteConsoleCommandSender remoteConsole = new CraftRemoteConsoleCommandSender(this);

    public RconConsoleSource(MinecraftServer server, SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        this.server = server;
    }

    public void prepareForCommand() {
        this.buffer.setLength(0);
    }

    public String getCommandResponse() {
        return this.buffer.toString();
    }

    public CommandSourceStack createCommandSourceStack() {
        ServerLevel serverLevel = this.server.overworld();
        return new CommandSourceStack(this, Vec3.atLowerCornerOf(serverLevel.getRespawnData().pos()), Vec2.ZERO, serverLevel, LevelBasedPermissionSet.OWNER, RCON, RCON_COMPONENT, this.server, null);
    }

    public void sendMessage(String message) {
        this.buffer.append(message);
    }

    @Override
    public CommandSender getBukkitSender(CommandSourceStack wrapper) {
        return this.remoteConsole;
    }

    @Override
    public void sendSystemMessage(Component message) {
        this.buffer.append(message.getString());
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public boolean shouldInformAdmins() {
        return this.server.shouldRconBroadcast();
    }
}

