/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.waypoints;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.waypoints.WaypointManager;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class ServerWaypointManager
implements WaypointManager<WaypointTransmitter> {
    private final Set<WaypointTransmitter> waypoints = new HashSet<WaypointTransmitter>();
    private final Set<ServerPlayer> players = new HashSet<ServerPlayer>();
    private final Table<ServerPlayer, WaypointTransmitter, WaypointTransmitter.Connection> connections = HashBasedTable.create();

    @Override
    public void trackWaypoint(WaypointTransmitter waypoint) {
        this.waypoints.add(waypoint);
        for (ServerPlayer serverPlayer : this.players) {
            this.createConnection(serverPlayer, waypoint);
        }
    }

    @Override
    public void updateWaypoint(WaypointTransmitter waypoint) {
        if (this.waypoints.contains(waypoint)) {
            Map map = Tables.transpose(this.connections).row((Object)waypoint);
            Sets.SetView set = Sets.difference(this.players, map.keySet());
            for (Map.Entry entry : ImmutableSet.copyOf(map.entrySet())) {
                this.updateConnection((ServerPlayer)entry.getKey(), waypoint, (WaypointTransmitter.Connection)entry.getValue());
            }
            for (ServerPlayer serverPlayer : set) {
                this.createConnection(serverPlayer, waypoint);
            }
        }
    }

    @Override
    public void untrackWaypoint(WaypointTransmitter waypoint) {
        this.connections.column((Object)waypoint).forEach((serverPlayer, connection) -> connection.disconnect());
        Tables.transpose(this.connections).row((Object)waypoint).clear();
        this.waypoints.remove(waypoint);
    }

    public void addPlayer(ServerPlayer player) {
        this.players.add(player);
        for (WaypointTransmitter waypointTransmitter : this.waypoints) {
            this.createConnection(player, waypointTransmitter);
        }
        if (player.isTransmittingWaypoint()) {
            this.trackWaypoint(player);
        }
    }

    public void updatePlayer(ServerPlayer player) {
        Map map = this.connections.row((Object)player);
        Sets.SetView set = Sets.difference(this.waypoints, map.keySet());
        for (Map.Entry entry : ImmutableSet.copyOf(map.entrySet())) {
            this.updateConnection(player, (WaypointTransmitter)entry.getKey(), (WaypointTransmitter.Connection)entry.getValue());
        }
        for (WaypointTransmitter waypointTransmitter : set) {
            this.createConnection(player, waypointTransmitter);
        }
    }

    public void removePlayer(ServerPlayer player) {
        this.connections.row((Object)player).values().removeIf(connection -> {
            connection.disconnect();
            return true;
        });
        this.untrackWaypoint(player);
        this.players.remove(player);
    }

    public void breakAllConnections() {
        this.connections.values().forEach(WaypointTransmitter.Connection::disconnect);
        this.connections.clear();
    }

    public void remakeConnections(WaypointTransmitter waypoint) {
        for (ServerPlayer serverPlayer : this.players) {
            this.createConnection(serverPlayer, waypoint);
        }
    }

    public Set<WaypointTransmitter> transmitters() {
        return this.waypoints;
    }

    private static boolean isLocatorBarEnabledFor(ServerPlayer player) {
        return player.level().getGameRules().get(GameRules.LOCATOR_BAR);
    }

    private void createConnection(ServerPlayer player, WaypointTransmitter waypoint) {
        if (player != waypoint && ServerWaypointManager.isLocatorBarEnabledFor(player)) {
            waypoint.makeWaypointConnectionWith(player).ifPresentOrElse(connection -> {
                this.connections.put((Object)player, (Object)waypoint, connection);
                connection.connect();
            }, () -> {
                WaypointTransmitter.Connection connection = (WaypointTransmitter.Connection)this.connections.remove((Object)player, (Object)waypoint);
                if (connection != null) {
                    connection.disconnect();
                }
            });
        }
    }

    private void updateConnection(ServerPlayer player, WaypointTransmitter waypoint, WaypointTransmitter.Connection connection) {
        if (player != waypoint && ServerWaypointManager.isLocatorBarEnabledFor(player)) {
            if (!connection.isBroken()) {
                connection.update();
            } else {
                waypoint.makeWaypointConnectionWith(player).ifPresentOrElse(connection1 -> {
                    connection1.connect();
                    this.connections.put((Object)player, (Object)waypoint, connection1);
                }, () -> {
                    connection.disconnect();
                    this.connections.remove((Object)player, (Object)waypoint);
                });
            }
        }
    }
}

