/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.papermc.paper.plugin.lifecycle.event.registrar.ReloadableRegistrarEvent;
import io.papermc.paper.tag.PaperTagListenerManager;
import io.papermc.paper.tag.TagEventConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagFile;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.StrictJsonParser;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TagLoader<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ElementLookup<T> elementLookup;
    private final String directory;

    public TagLoader(ElementLookup<T> elementLookup, String directory) {
        this.elementLookup = elementLookup;
        this.directory = directory;
    }

    public Map<Identifier, List<EntryWithSource>> load(ResourceManager resourceManager) {
        HashMap<Identifier, List<EntryWithSource>> map = new HashMap<Identifier, List<EntryWithSource>>();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json(this.directory);
        for (Map.Entry<Identifier, List<Resource>> entry : fileToIdConverter.listMatchingResourceStacks(resourceManager).entrySet()) {
            Identifier identifier = entry.getKey();
            Identifier identifier1 = fileToIdConverter.fileToId(identifier);
            for (Resource resource : entry.getValue()) {
                try {
                    BufferedReader reader = resource.openAsReader();
                    try {
                        JsonElement jsonElement = StrictJsonParser.parse(reader);
                        List list = map.computeIfAbsent(identifier1, path -> new ArrayList());
                        TagFile tagFile = (TagFile)TagFile.CODEC.parse(new Dynamic<JsonElement>((DynamicOps<JsonElement>)JsonOps.INSTANCE, jsonElement)).getOrThrow();
                        if (tagFile.replace()) {
                            list.clear();
                        }
                        String string = resource.sourcePackId();
                        tagFile.entries().forEach(entry1 -> list.add(new EntryWithSource((TagEntry)entry1, string)));
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception var17) {
                    LOGGER.error("Couldn't read tag list {} from {} in data pack {}", new Object[]{identifier1, identifier, resource.sourcePackId(), var17});
                }
            }
        }
        return map;
    }

    private Either<List<EntryWithSource>, List<T>> tryBuildTag(TagEntry.Lookup<T> lookup, List<EntryWithSource> entries) {
        LinkedHashSet set = new LinkedHashSet();
        ArrayList<EntryWithSource> list = new ArrayList<EntryWithSource>();
        for (EntryWithSource entryWithSource : entries) {
            if (entryWithSource.entry().build(lookup, set::add)) continue;
            list.add(entryWithSource);
        }
        return list.isEmpty() ? Either.right(List.copyOf(set)) : Either.left(list);
    }

    public Map<Identifier, List<T>> build(Map<Identifier, List<EntryWithSource>> builders, @Nullable TagEventConfig<T, ?> eventConfig) {
        builders = PaperTagListenerManager.INSTANCE.firePreFlattenEvent(builders, eventConfig);
        final HashMap map = new HashMap();
        TagEntry.Lookup lookup = new TagEntry.Lookup<T>(){

            @Override
            public @Nullable T element(Identifier id, boolean required) {
                return TagLoader.this.elementLookup.get(id, required).orElse(null);
            }

            @Override
            public @Nullable Collection<T> tag(Identifier id) {
                return (Collection)map.get(id);
            }
        };
        DependencySorter<Identifier, SortingEntry> dependencySorter = new DependencySorter<Identifier, SortingEntry>();
        builders.forEach((path, entries) -> dependencySorter.addEntry((Identifier)path, new SortingEntry((List<EntryWithSource>)entries)));
        dependencySorter.orderByDependencies((path, sortingEntry) -> this.tryBuildTag(lookup, sortingEntry.entries).ifLeft(list -> LOGGER.error("Couldn't load tag {} as it is missing following references: {}", path, (Object)list.stream().map(Objects::toString).collect(Collectors.joining(", ")))).ifRight(list -> map.put((Identifier)path, list)));
        return PaperTagListenerManager.INSTANCE.firePostFlattenEvent(map, eventConfig);
    }

    public static <T> void loadTagsFromNetwork(TagNetworkSerialization.NetworkPayload payload, WritableRegistry<T> registry) {
        payload.resolve(registry).tags.forEach(registry::bindTag);
    }

    public static List<Registry.PendingTags<?>> loadTagsForExistingRegistries(ResourceManager resourceManager, RegistryAccess registryAccess) {
        return TagLoader.loadTagsForExistingRegistries(resourceManager, registryAccess, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static List<Registry.PendingTags<?>> loadTagsForExistingRegistries(ResourceManager resourceManager, RegistryAccess registryAccess, ReloadableRegistrarEvent.Cause cause) {
        return registryAccess.registries().map(registryEntry -> TagLoader.loadPendingTags(resourceManager, registryEntry.value(), cause)).flatMap(Optional::stream).collect(Collectors.toUnmodifiableList());
    }

    public static <T> void loadTagsForRegistry(ResourceManager resourceManager, WritableRegistry<T> registry) {
        TagLoader.loadTagsForRegistry(resourceManager, registry, ReloadableRegistrarEvent.Cause.INITIAL);
    }

    public static <T> void loadTagsForRegistry(ResourceManager resourceManager, WritableRegistry<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey resourceKey = registry.key();
        TagLoader<Holder<Holder<T>>> tagLoader = new TagLoader<Holder<Holder<T>>>(ElementLookup.fromWritableRegistry(registry), Registries.tagsDirPath(resourceKey));
        tagLoader.build(tagLoader.load(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause)).forEach((identifier, list) -> registry.bindTag(TagKey.create(resourceKey, identifier), (List)list));
    }

    private static <T> Map<TagKey<T>, List<Holder<T>>> wrapTags(ResourceKey<? extends Registry<T>> registryKey, Map<Identifier, List<Holder<T>>> tags) {
        return tags.entrySet().stream().collect(Collectors.toUnmodifiableMap(entry -> TagKey.create(registryKey, (Identifier)entry.getKey()), Map.Entry::getValue));
    }

    private static <T> Optional<Registry.PendingTags<T>> loadPendingTags(ResourceManager resourceManager, Registry<T> registry, ReloadableRegistrarEvent.Cause cause) {
        ResourceKey<Registry<T>> resourceKey = registry.key();
        TagLoader<Holder<Holder<T>>> tagLoader = new TagLoader<Holder<Holder<T>>>(ElementLookup.fromFrozenRegistry(registry), Registries.tagsDirPath(resourceKey));
        LoadResult<T> loadResult = new LoadResult<T>(resourceKey, TagLoader.wrapTags(registry.key(), tagLoader.build(tagLoader.load(resourceManager), PaperTagListenerManager.INSTANCE.createEventConfig(registry, cause))));
        return loadResult.tags().isEmpty() ? Optional.empty() : Optional.of(registry.prepareTagReload(loadResult));
    }

    public static List<HolderLookup.RegistryLookup<?>> buildUpdatedLookups(RegistryAccess.Frozen registry, List<Registry.PendingTags<?>> tags) {
        ArrayList list = new ArrayList();
        registry.registries().forEach(registryEntry -> {
            Registry.PendingTags pendingTags = TagLoader.findTagsForRegistry(tags, registryEntry.key());
            list.add(pendingTags != null ? pendingTags.lookup() : registryEntry.value());
        });
        return list;
    }

    private static @Nullable Registry.PendingTags<?> findTagsForRegistry(List<Registry.PendingTags<?>> tags, ResourceKey<? extends Registry<?>> registryKey) {
        for (Registry.PendingTags<?> pendingTags : tags) {
            if (pendingTags.key() != registryKey) continue;
            return pendingTags;
        }
        return null;
    }

    public static interface ElementLookup<T> {
        public Optional<? extends T> get(Identifier var1, boolean var2);

        public static <T> ElementLookup<? extends Holder<T>> fromFrozenRegistry(Registry<T> registry) {
            return (id, required) -> registry.get(id);
        }

        public static <T> ElementLookup<Holder<T>> fromWritableRegistry(WritableRegistry<T> registry) {
            HolderGetter holderGetter = registry.createRegistrationLookup();
            return (id, required) -> (required ? holderGetter : registry).get(ResourceKey.create(registry.key(), id));
        }
    }

    public record EntryWithSource(TagEntry entry, String source) {
        @Override
        public String toString() {
            return String.valueOf(this.entry) + " (from " + this.source + ")";
        }
    }

    public record LoadResult<T>(ResourceKey<? extends Registry<T>> key, Map<TagKey<T>, List<Holder<T>>> tags) {
    }

    record SortingEntry(List<EntryWithSource> entries) implements DependencySorter.Entry<Identifier>
    {
        @Override
        public void visitRequiredDependencies(Consumer<Identifier> visitor) {
            this.entries.forEach(entry -> entry.entry.visitRequiredDependencies(visitor));
        }

        @Override
        public void visitOptionalDependencies(Consumer<Identifier> visitor) {
            this.entries.forEach(entry -> entry.entry.visitOptionalDependencies(visitor));
        }
    }
}

