/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DependencySorter<K, V extends Entry<K>> {
    private final Map<K, V> contents = new HashMap();

    public DependencySorter<K, V> addEntry(K key, V value) {
        this.contents.put(key, value);
        return this;
    }

    private void visitDependenciesAndElement(Multimap<K, K> dependencies, Set<K> visited, K element, BiConsumer<K, V> action) {
        if (visited.add(element)) {
            dependencies.get(element).forEach(object -> this.visitDependenciesAndElement(dependencies, visited, object, action));
            Entry entry = (Entry)this.contents.get(element);
            if (entry != null) {
                action.accept(element, entry);
            }
        }
    }

    private static <K> boolean isCyclic(Multimap<K, K> dependencies, K source, K target) {
        Collection collection = dependencies.get(target);
        return collection.contains(source) || collection.stream().anyMatch(object -> DependencySorter.isCyclic(dependencies, source, object));
    }

    private static <K> void addDependencyIfNotCyclic(Multimap<K, K> dependencies, K source, K target) {
        if (!DependencySorter.isCyclic(dependencies, source, target)) {
            dependencies.put(source, target);
        }
    }

    public void orderByDependencies(BiConsumer<K, V> action) {
        HashMultimap multimap = HashMultimap.create();
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.lambda$orderByDependencies$3((Multimap)multimap, arg_0, arg_1));
        this.contents.forEach((arg_0, arg_1) -> DependencySorter.lambda$orderByDependencies$5((Multimap)multimap, arg_0, arg_1));
        HashSet set = new HashSet();
        this.contents.keySet().forEach(arg_0 -> this.lambda$orderByDependencies$6((Multimap)multimap, set, action, arg_0));
    }

    private /* synthetic */ void lambda$orderByDependencies$6(Multimap multimap, Set set, BiConsumer action, Object object) {
        this.visitDependenciesAndElement(multimap, set, object, action);
    }

    private static /* synthetic */ void lambda$orderByDependencies$5(Multimap multimap, Object object, Entry entry) {
        entry.visitOptionalDependencies(object1 -> DependencySorter.addDependencyIfNotCyclic(multimap, object, object1));
    }

    private static /* synthetic */ void lambda$orderByDependencies$3(Multimap multimap, Object object, Entry entry) {
        entry.visitRequiredDependencies(object1 -> DependencySorter.addDependencyIfNotCyclic(multimap, object, object1));
    }

    public static interface Entry<K> {
        public void visitRequiredDependencies(Consumer<K> var1);

        public void visitOptionalDependencies(Consumer<K> var1);
    }
}

