/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.Ease;
import net.minecraft.util.ExtraCodecs;

public interface EasingType {
    public static final ExtraCodecs.LateBoundIdMapper<String, EasingType> SIMPLE_REGISTRY = new ExtraCodecs.LateBoundIdMapper();
    public static final Codec<EasingType> CODEC = Codec.either(SIMPLE_REGISTRY.codec((Codec<String>)Codec.STRING), CubicBezier.CODEC).xmap(Either::unwrap, easingType -> {
        Either<EasingType, Object> either;
        if (easingType instanceof CubicBezier) {
            CubicBezier cubicBezier = (CubicBezier)easingType;
            either = Either.right(cubicBezier);
        } else {
            either = Either.left(easingType);
        }
        return either;
    });
    public static final EasingType CONSTANT = EasingType.registerSimple("constant", x -> 0.0f);
    public static final EasingType LINEAR = EasingType.registerSimple("linear", x -> x);
    public static final EasingType IN_BACK = EasingType.registerSimple("in_back", Ease::inBack);
    public static final EasingType IN_BOUNCE = EasingType.registerSimple("in_bounce", Ease::inBounce);
    public static final EasingType IN_CIRC = EasingType.registerSimple("in_circ", Ease::inCirc);
    public static final EasingType IN_CUBIC = EasingType.registerSimple("in_cubic", Ease::inCubic);
    public static final EasingType IN_ELASTIC = EasingType.registerSimple("in_elastic", Ease::inElastic);
    public static final EasingType IN_EXPO = EasingType.registerSimple("in_expo", Ease::inExpo);
    public static final EasingType IN_QUAD = EasingType.registerSimple("in_quad", Ease::inQuad);
    public static final EasingType IN_QUART = EasingType.registerSimple("in_quart", Ease::inQuart);
    public static final EasingType IN_QUINT = EasingType.registerSimple("in_quint", Ease::inQuint);
    public static final EasingType IN_SINE = EasingType.registerSimple("in_sine", Ease::inSine);
    public static final EasingType IN_OUT_BACK = EasingType.registerSimple("in_out_back", Ease::inOutBack);
    public static final EasingType IN_OUT_BOUNCE = EasingType.registerSimple("in_out_bounce", Ease::inOutBounce);
    public static final EasingType IN_OUT_CIRC = EasingType.registerSimple("in_out_circ", Ease::inOutCirc);
    public static final EasingType IN_OUT_CUBIC = EasingType.registerSimple("in_out_cubic", Ease::inOutCubic);
    public static final EasingType IN_OUT_ELASTIC = EasingType.registerSimple("in_out_elastic", Ease::inOutElastic);
    public static final EasingType IN_OUT_EXPO = EasingType.registerSimple("in_out_expo", Ease::inOutExpo);
    public static final EasingType IN_OUT_QUAD = EasingType.registerSimple("in_out_quad", Ease::inOutQuad);
    public static final EasingType IN_OUT_QUART = EasingType.registerSimple("in_out_quart", Ease::inOutQuart);
    public static final EasingType IN_OUT_QUINT = EasingType.registerSimple("in_out_quint", Ease::inOutQuint);
    public static final EasingType IN_OUT_SINE = EasingType.registerSimple("in_out_sine", Ease::inOutSine);
    public static final EasingType OUT_BACK = EasingType.registerSimple("out_back", Ease::outBack);
    public static final EasingType OUT_BOUNCE = EasingType.registerSimple("out_bounce", Ease::outBounce);
    public static final EasingType OUT_CIRC = EasingType.registerSimple("out_circ", Ease::outCirc);
    public static final EasingType OUT_CUBIC = EasingType.registerSimple("out_cubic", Ease::outCubic);
    public static final EasingType OUT_ELASTIC = EasingType.registerSimple("out_elastic", Ease::outElastic);
    public static final EasingType OUT_EXPO = EasingType.registerSimple("out_expo", Ease::outExpo);
    public static final EasingType OUT_QUAD = EasingType.registerSimple("out_quad", Ease::outQuad);
    public static final EasingType OUT_QUART = EasingType.registerSimple("out_quart", Ease::outQuart);
    public static final EasingType OUT_QUINT = EasingType.registerSimple("out_quint", Ease::outQuint);
    public static final EasingType OUT_SINE = EasingType.registerSimple("out_sine", Ease::outSine);

    public static EasingType registerSimple(String id, EasingType easing) {
        SIMPLE_REGISTRY.put(id, easing);
        return easing;
    }

    public static EasingType cubicBezier(float x1, float y1, float x2, float y2) {
        return new CubicBezier(new CubicBezierControls(x1, y1, x2, y2));
    }

    public static EasingType symmetricCubicBezier(float x1, float y1) {
        return EasingType.cubicBezier(x1, y1, 1.0f - x1, 1.0f - y1);
    }

    public float apply(float var1);

    public static final class CubicBezier
    implements EasingType {
        public static final Codec<CubicBezier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CubicBezierControls.CODEC.fieldOf("cubic_bezier").forGetter(cubicBezier -> cubicBezier.controls)).apply((Applicative)instance, CubicBezier::new));
        private static final int NEWTON_RAPHSON_ITERATIONS = 4;
        private final CubicBezierControls controls;
        private final CubicCurve xCurve;
        private final CubicCurve yCurve;

        public CubicBezier(CubicBezierControls controls) {
            this.controls = controls;
            this.xCurve = CubicBezier.curveFromControls(controls.x1, controls.x2);
            this.yCurve = CubicBezier.curveFromControls(controls.y1, controls.y2);
        }

        private static CubicCurve curveFromControls(float v1, float v2) {
            return new CubicCurve(3.0f * v1 - 3.0f * v2 + 1.0f, -6.0f * v1 + 3.0f * v2, 3.0f * v1);
        }

        @Override
        public float apply(float x) {
            float f1;
            float f = x;
            for (int i = 0; i < 4 && !((f1 = this.xCurve.sampleGradient(f)) < 1.0E-5f); ++i) {
                float f2 = this.xCurve.sample(f) - x;
                f -= f2 / f1;
            }
            return this.yCurve.sample(f);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof CubicBezier)) return false;
            CubicBezier cubicBezier = (CubicBezier)other;
            if (!this.controls.equals(cubicBezier.controls)) return false;
            return true;
        }

        public int hashCode() {
            return this.controls.hashCode();
        }

        public String toString() {
            return "CubicBezier(" + this.controls.x1 + ", " + this.controls.y1 + ", " + this.controls.x2 + ", " + this.controls.y2 + ")";
        }

        record CubicCurve(float a, float b, float c) {
            public float sample(float t) {
                return ((this.a * t + this.b) * t + this.c) * t;
            }

            public float sampleGradient(float t) {
                return (3.0f * this.a * t + 2.0f * this.b) * t + this.c;
            }
        }
    }

    public record CubicBezierControls(float x1, float y1, float x2, float y2) {
        public static final Codec<CubicBezierControls> CODEC = Codec.FLOAT.listOf(4, 4).xmap(list -> new CubicBezierControls(((Float)list.get(0)).floatValue(), ((Float)list.get(1)).floatValue(), ((Float)list.get(2)).floatValue(), ((Float)list.get(3)).floatValue()), cubicBezierControls -> List.of(Float.valueOf(cubicBezierControls.x1), Float.valueOf(cubicBezierControls.y1), Float.valueOf(cubicBezierControls.x2), Float.valueOf(cubicBezierControls.y2))).validate(CubicBezierControls::validate);

        private DataResult<CubicBezierControls> validate() {
            if (this.x1 < 0.0f || this.x1 > 1.0f) {
                return DataResult.error(() -> "x1 must be in range [0; 1]");
            }
            return !(this.x2 < 0.0f) && !(this.x2 > 1.0f) ? DataResult.success((Object)this) : DataResult.error(() -> "x2 must be in range [0; 1]");
        }
    }
}

