/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.primitives.UnsignedBytes;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ARGB;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Util;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.jspecify.annotations.Nullable;

public class ExtraCodecs {
    public static final Codec<JsonElement> JSON = ExtraCodecs.converter(JsonOps.INSTANCE);
    public static final Codec<Object> JAVA = ExtraCodecs.converter(JavaOps.INSTANCE);
    public static final Codec<Tag> NBT = ExtraCodecs.converter(NbtOps.INSTANCE);
    public static final Codec<Vector2fc> VECTOR2F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 2).map(list1 -> new Vector2f(((Float)list1.get(0)).floatValue(), ((Float)list1.get(1)).floatValue())), vector2fc -> List.of(Float.valueOf(vector2fc.x()), Float.valueOf(vector2fc.y())));
    public static final Codec<Vector3fc> VECTOR3F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 3).map(list1 -> new Vector3f(((Float)list1.get(0)).floatValue(), ((Float)list1.get(1)).floatValue(), ((Float)list1.get(2)).floatValue())), vector3fc -> List.of(Float.valueOf(vector3fc.x()), Float.valueOf(vector3fc.y()), Float.valueOf(vector3fc.z())));
    public static final Codec<Vector3ic> VECTOR3I = Codec.INT.listOf().comapFlatMap(list -> Util.fixedSize(list, 3).map(list1 -> new Vector3i(((Integer)list1.get(0)).intValue(), ((Integer)list1.get(1)).intValue(), ((Integer)list1.get(2)).intValue())), vector3ic -> List.of(Integer.valueOf(vector3ic.x()), Integer.valueOf(vector3ic.y()), Integer.valueOf(vector3ic.z())));
    public static final Codec<Vector4fc> VECTOR4F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 4).map(list1 -> new Vector4f(((Float)list1.get(0)).floatValue(), ((Float)list1.get(1)).floatValue(), ((Float)list1.get(2)).floatValue(), ((Float)list1.get(3)).floatValue())), vector4fc -> List.of(Float.valueOf(vector4fc.x()), Float.valueOf(vector4fc.y()), Float.valueOf(vector4fc.z()), Float.valueOf(vector4fc.w())));
    public static final Codec<Quaternionfc> QUATERNIONF_COMPONENTS = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 4).map(list1 -> new Quaternionf(((Float)list1.get(0)).floatValue(), ((Float)list1.get(1)).floatValue(), ((Float)list1.get(2)).floatValue(), ((Float)list1.get(3)).floatValue()).normalize()), quaternionfc -> List.of(Float.valueOf(quaternionfc.x()), Float.valueOf(quaternionfc.y()), Float.valueOf(quaternionfc.z()), Float.valueOf(quaternionfc.w())));
    public static final Codec<AxisAngle4f> AXISANGLE4F = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("angle").forGetter(axisAngle4f -> Float.valueOf(axisAngle4f.angle)), (App)VECTOR3F.fieldOf("axis").forGetter(axisAngle4f -> new Vector3f(axisAngle4f.x, axisAngle4f.y, axisAngle4f.z))).apply((Applicative)instance, AxisAngle4f::new));
    public static final Codec<Quaternionfc> QUATERNIONF = Codec.withAlternative(QUATERNIONF_COMPONENTS, (Codec)AXISANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new));
    public static final Codec<Matrix4fc> MATRIX4F = Codec.FLOAT.listOf().comapFlatMap(list -> Util.fixedSize(list, 16).map(list1 -> {
        Matrix4f matrix4f = new Matrix4f();
        for (int i = 0; i < list1.size(); ++i) {
            matrix4f.setRowColumn(i >> 2, i & 3, ((Float)list1.get(i)).floatValue());
        }
        return matrix4f.determineProperties();
    }), matrix4fc -> {
        FloatArrayList list = new FloatArrayList(16);
        for (int i = 0; i < 16; ++i) {
            list.add(matrix4fc.getRowColumn(i >> 2, i & 3));
        }
        return list;
    });
    private static final String HEX_COLOR_PREFIX = "#";
    public static final Codec<Integer> RGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR3F, vector3fc -> ARGB.colorFromFloat(1.0f, vector3fc.x(), vector3fc.y(), vector3fc.z()));
    public static final Codec<Integer> ARGB_COLOR_CODEC = Codec.withAlternative((Codec)Codec.INT, VECTOR4F, vector4fc -> ARGB.colorFromFloat(vector4fc.w(), vector4fc.x(), vector4fc.y(), vector4fc.z()));
    public static final Codec<Integer> STRING_RGB_COLOR = Codec.withAlternative((Codec)ExtraCodecs.hexColor(6).xmap(ARGB::opaque, ARGB::transparent), RGB_COLOR_CODEC);
    public static final Codec<Integer> STRING_ARGB_COLOR = Codec.withAlternative(ExtraCodecs.hexColor(8), ARGB_COLOR_CODEC);
    public static final Codec<Integer> UNSIGNED_BYTE = Codec.BYTE.flatComapMap(UnsignedBytes::toInt, integer -> integer > 255 ? DataResult.error(() -> "Unsigned byte was too large: " + integer + " > 255") : DataResult.success((Object)integer.byteValue()));
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, integer -> "Value must be non-negative: " + integer);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, integer -> "Value must be positive: " + integer);
    public static final Codec<Long> NON_NEGATIVE_LONG = ExtraCodecs.longRangeWithMessage(0L, Long.MAX_VALUE, _long -> "Value must be non-negative: " + _long);
    public static final Codec<Long> POSITIVE_LONG = ExtraCodecs.longRangeWithMessage(1L, Long.MAX_VALUE, _long -> "Value must be positive: " + _long);
    public static final Codec<Float> NON_NEGATIVE_FLOAT = ExtraCodecs.floatRangeMinInclusiveWithMessage(0.0f, Float.MAX_VALUE, _float -> "Value must be non-negative: " + _float);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, _float -> "Value must be positive: " + _float);
    public static final Codec<Pattern> PATTERN = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Pattern.compile(string));
        }
        catch (PatternSyntaxException var2) {
            return DataResult.error(() -> "Invalid regex pattern '" + string + "': " + var2.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> INSTANT_ISO8601 = ExtraCodecs.temporalCodec(DateTimeFormatter.ISO_INSTANT).xmap(Instant::from, Function.identity());
    public static final Codec<byte[]> BASE64_STRING = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)string));
        }
        catch (IllegalArgumentException var2) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, bytes -> Base64.getEncoder().encodeToString((byte[])bytes));
    public static final Codec<String> ESCAPED_STRING = Codec.STRING.comapFlatMap(string -> DataResult.success((Object)StringEscapeUtils.unescapeJava((String)string)), StringEscapeUtils::escapeJava);
    public static final Codec<TagOrElementLocation> TAG_OR_ELEMENT_ID = Codec.STRING.comapFlatMap(value -> value.startsWith(HEX_COLOR_PREFIX) ? Identifier.read(value.substring(1)).map(identifier -> new TagOrElementLocation((Identifier)identifier, true)) : Identifier.read(value).map(identifier -> new TagOrElementLocation((Identifier)identifier, false)), TagOrElementLocation::decoratedId);
    public static final Function<Optional<Long>, OptionalLong> toOptionalLong = optional -> optional.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> fromOptionalLong = optionalLong -> optionalLong.isPresent() ? Optional.of(optionalLong.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> BIT_SET = Codec.LONG_STREAM.xmap(longStream -> BitSet.valueOf(longStream.toArray()), bitSet -> Arrays.stream(bitSet.toLongArray()));
    public static final int MAX_PROPERTY_NAME_LENGTH = 64;
    public static final int MAX_PROPERTY_VALUE_LENGTH = Short.MAX_VALUE;
    public static final int MAX_PROPERTY_SIGNATURE_LENGTH = 1024;
    public static final int MAX_PROPERTIES = 16;
    private static final Codec<Property> PROPERTY = RecordCodecBuilder.create(instance -> instance.group((App)Codec.sizeLimitedString((int)64).fieldOf("name").forGetter(Property::name), (App)Codec.sizeLimitedString((int)Short.MAX_VALUE).fieldOf("value").forGetter(Property::value), (App)Codec.sizeLimitedString((int)1024).optionalFieldOf("signature").forGetter(property -> Optional.ofNullable(property.signature()))).apply((Applicative)instance, (string, string1, optional) -> new Property(string, string1, (String)optional.orElse(null))));
    public static final Codec<PropertyMap> PROPERTY_MAP = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).validate(map -> map.size() > 16 ? DataResult.error(() -> "Cannot have more than 16 properties, but was " + map.size()) : DataResult.success((Object)map)), (Codec)PROPERTY.sizeLimitedListOf(16)).xmap(either -> {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        either.ifLeft(map -> map.forEach((string, list) -> {
            for (String string1 : list) {
                builder.put(string, (Object)new Property(string, string1));
            }
        })).ifRight(list -> {
            for (Property property : list) {
                builder.put((Object)property.name(), (Object)property);
            }
        });
        return new PropertyMap((Multimap)builder.build());
    }, propertyMap -> Either.right(propertyMap.values().stream().toList()));
    public static final Codec<String> PLAYER_NAME = Codec.string((int)0, (int)16).validate(value -> StringUtil.isValidPlayerName(value) ? DataResult.success((Object)value) : DataResult.error(() -> "Player name contained disallowed characters: '" + value + "'"));
    public static final Codec<GameProfile> AUTHLIB_GAME_PROFILE = ExtraCodecs.gameProfileCodec(UUIDUtil.AUTHLIB_CODEC).codec();
    public static final MapCodec<GameProfile> STORED_GAME_PROFILE = ExtraCodecs.gameProfileCodec(UUIDUtil.CODEC);
    public static final Codec<String> NON_EMPTY_STRING = Codec.STRING.validate(value -> value.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)value));
    public static final Codec<Integer> CODEPOINT = Codec.STRING.comapFlatMap(string -> {
        int[] ints = string.codePoints().toArray();
        return ints.length != 1 ? DataResult.error(() -> "Expected one codepoint, got: " + string) : DataResult.success((Object)ints[0]);
    }, Character::toString);
    public static final Codec<String> RESOURCE_PATH_CODEC = Codec.STRING.validate(string -> !Identifier.isValidPath(string) ? DataResult.error(() -> "Invalid string to use as a resource path element: " + string) : DataResult.success((Object)string));
    public static final Codec<URI> UNTRUSTED_URI = Codec.STRING.comapFlatMap(string -> {
        try {
            return DataResult.success((Object)Util.parseAndValidateUntrustedUri(string));
        }
        catch (URISyntaxException var2) {
            return DataResult.error(var2::getMessage);
        }
    }, URI::toString);
    public static final Codec<String> CHAT_STRING = Codec.STRING.validate(string -> {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (StringUtil.isAllowedChatCharacter(c)) continue;
            return DataResult.error(() -> "Disallowed chat character: '" + c + "'");
        }
        return DataResult.success((Object)string);
    });

    public static <T> Codec<T> converter(DynamicOps<T> ops) {
        return Codec.PASSTHROUGH.xmap(data -> data.convert(ops).getValue(), value -> new Dynamic<Object>(ops, value));
    }

    private static Codec<Integer> hexColor(int digits) {
        long l = (1L << digits * 4) - 1L;
        return Codec.STRING.comapFlatMap(string -> {
            if (!string.startsWith(HEX_COLOR_PREFIX)) {
                return DataResult.error(() -> "Hex color must begin with #");
            }
            int i = string.length() - HEX_COLOR_PREFIX.length();
            if (i != digits) {
                return DataResult.error(() -> "Hex color is wrong size, expected " + digits + " digits but got " + i);
            }
            try {
                long l1 = HexFormat.fromHexDigitsToLong(string, HEX_COLOR_PREFIX.length(), string.length());
                return l1 >= 0L && l1 <= l ? DataResult.success((Object)((int)l1)) : DataResult.error(() -> "Color value out of range: " + string);
            }
            catch (NumberFormatException var7) {
                return DataResult.error(() -> "Invalid color value: " + string);
            }
        }, integer -> HEX_COLOR_PREFIX + HexFormat.of().toHexDigits(integer.intValue(), digits));
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> codec, String minFieldName, String maxFieldName, BiFunction<P, P, DataResult<I>> factory, Function<I, P> minGetter, Function<I, P> maxGetter) {
        Codec codec1 = Codec.list(codec).comapFlatMap(list -> Util.fixedSize(list, 2).flatMap(list1 -> {
            Object object = list1.get(0);
            Object object1 = list1.get(1);
            return (DataResult)factory.apply(object, object1);
        }), object -> ImmutableList.of(minGetter.apply(object), maxGetter.apply(object)));
        Codec codec2 = RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf(minFieldName).forGetter(Pair::getFirst), (App)codec.fieldOf(maxFieldName).forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of)).comapFlatMap(pair -> (DataResult)factory.apply(pair.getFirst(), pair.getSecond()), object -> Pair.of(minGetter.apply(object), maxGetter.apply(object)));
        Codec codec3 = Codec.withAlternative((Codec)codec1, (Codec)codec2);
        return Codec.either(codec, (Codec)codec3).comapFlatMap(either -> either.map(object -> (DataResult)factory.apply(object, object), DataResult::success), object -> {
            Object object2;
            Object object1 = minGetter.apply(object);
            return Objects.equals(object1, object2 = maxGetter.apply(object)) ? Either.left(object1) : Either.right(object);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A value) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> ops, T input, DataResult<Pair<A, T>> a) {
                MutableObject mutableObject = new MutableObject();
                Optional optional = a.resultOrPartial(arg_0 -> ((MutableObject)mutableObject).setValue(arg_0));
                return optional.isPresent() ? a : DataResult.error(() -> "(" + (String)mutableObject.get() + " -> using default)", (Object)Pair.of((Object)value, input));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> ops, A input, DataResult<T> t) {
                return t;
            }

            public String toString() {
                return "OrElsePartial[" + String.valueOf(value) + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> encoder, IntFunction<@Nullable E> decoder, int notFoundValue) {
        return Codec.INT.flatXmap(integer -> Optional.ofNullable(decoder.apply((int)integer)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + integer)), object -> {
            int i = encoder.applyAsInt(object);
            return i == notFoundValue ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(object)) : DataResult.success((Object)i);
        });
    }

    public static <I, E> Codec<E> idResolverCodec(Codec<I> idCodec, Function<I, @Nullable E> idToValue, Function<E, @Nullable I> valueToId) {
        return idCodec.flatXmap(object -> {
            Object object1 = idToValue.apply(object);
            return object1 == null ? DataResult.error(() -> "Unknown element id: " + String.valueOf(object)) : DataResult.success(object1);
        }, object -> {
            Object object1 = valueToId.apply(object);
            return object1 == null ? DataResult.error(() -> "Element with unknown id: " + String.valueOf(object)) : DataResult.success(object1);
        });
    }

    public static <E> Codec<E> orCompressed(final Codec<E> first, final Codec<E> second) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E input, DynamicOps<T> ops, T prefix) {
                return ops.compressMaps() ? second.encode(input, ops, prefix) : first.encode(input, ops, prefix);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> ops, T input) {
                return ops.compressMaps() ? second.decode(ops, input) : first.decode(ops, input);
            }

            public String toString() {
                return String.valueOf(first) + " orCompressed " + String.valueOf(second);
            }
        };
    }

    public static <E> MapCodec<E> orCompressed(final MapCodec<E> first, final MapCodec<E> second) {
        return new MapCodec<E>(){

            public <T> RecordBuilder<T> encode(E input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return ops.compressMaps() ? second.encode(input, ops, prefix) : first.encode(input, ops, prefix);
            }

            public <T> DataResult<E> decode(DynamicOps<T> ops, MapLike<T> prefix) {
                return ops.compressMaps() ? second.decode(ops, prefix) : first.decode(ops, prefix);
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return second.keys(ops);
            }

            public String toString() {
                return String.valueOf(first) + " orCompressed " + String.valueOf(second);
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> codec, final Function<E, Lifecycle> applyLifecycle, final Function<E, Lifecycle> coApplyLifecycle) {
        return codec.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> dynamicOps, T object, DataResult<Pair<E, T>> dataResult) {
                return dataResult.result().map(pair -> dataResult.setLifecycle((Lifecycle)applyLifecycle.apply(pair.getFirst()))).orElse(dataResult);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> dynamicOps, E object, DataResult<T> dataResult) {
                return dataResult.setLifecycle((Lifecycle)coApplyLifecycle.apply(object));
            }

            public String toString() {
                return "WithLifecycle[" + String.valueOf(applyLifecycle) + " " + String.valueOf(coApplyLifecycle) + "]";
            }
        });
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> codec, Function<E, Lifecycle> lifecycleGetter) {
        return ExtraCodecs.overrideLifecycle(codec, lifecycleGetter, lifecycleGetter);
    }

    public static <K, V> StrictUnboundedMapCodec<K, V> strictUnboundedMap(Codec<K> key, Codec<V> value) {
        return new StrictUnboundedMapCodec<K, V>(key, value);
    }

    public static <E> Codec<List<E>> compactListCodec(Codec<E> elementCodec) {
        return ExtraCodecs.compactListCodec(elementCodec, elementCodec.listOf());
    }

    public static <E> Codec<List<E>> compactListCodec(Codec<E> elementCodec, Codec<List<E>> listCodec) {
        return Codec.either(listCodec, elementCodec).xmap(either -> either.map(list -> list, List::of), list -> list.size() == 1 ? Either.right(list.getFirst()) : Either.left(list));
    }

    private static Codec<Integer> intRangeWithMessage(int min, int max, Function<Integer, String> errorMessage) {
        return Codec.INT.validate(integer -> integer.compareTo(min) >= 0 && integer.compareTo(max) <= 0 ? DataResult.success((Object)integer) : DataResult.error(() -> (String)errorMessage.apply((Integer)integer)));
    }

    public static Codec<Integer> intRange(int min, int max) {
        return ExtraCodecs.intRangeWithMessage(min, max, integer -> "Value must be within range [" + min + ";" + max + "]: " + integer);
    }

    private static Codec<Long> longRangeWithMessage(long min, long max, Function<Long, String> errorMessage) {
        return Codec.LONG.validate(_long -> (long)_long.compareTo(min) >= 0L && (long)_long.compareTo(max) <= 0L ? DataResult.success((Object)_long) : DataResult.error(() -> (String)errorMessage.apply((Long)_long)));
    }

    public static Codec<Long> longRange(int min, int max) {
        return ExtraCodecs.longRangeWithMessage(min, max, _long -> "Value must be within range [" + min + ";" + max + "]: " + _long);
    }

    private static Codec<Float> floatRangeMinInclusiveWithMessage(float min, float max, Function<Float, String> errorMessage) {
        return Codec.FLOAT.validate(_float -> _float.compareTo(Float.valueOf(min)) >= 0 && _float.compareTo(Float.valueOf(max)) <= 0 ? DataResult.success((Object)_float) : DataResult.error(() -> (String)errorMessage.apply((Float)_float)));
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float min, float max, Function<Float, String> errorMessage) {
        return Codec.FLOAT.validate(_float -> _float.compareTo(Float.valueOf(min)) > 0 && _float.compareTo(Float.valueOf(max)) <= 0 ? DataResult.success((Object)_float) : DataResult.error(() -> (String)errorMessage.apply((Float)_float)));
    }

    public static Codec<Float> floatRange(float min, float max) {
        return ExtraCodecs.floatRangeMinInclusiveWithMessage(min, max, _float -> "Value must be within range [" + min + ";" + max + "]: " + _float);
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> codec) {
        return codec.validate(list -> list.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)list));
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> codec) {
        return codec.validate(holderSet -> holderSet.unwrap().right().filter(List::isEmpty).isPresent() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)holderSet));
    }

    public static <M extends Map<?, ?>> Codec<M> nonEmptyMap(Codec<M> mapCodec) {
        return mapCodec.validate(map -> map.isEmpty() ? DataResult.error(() -> "Map must have contents") : DataResult.success((Object)map));
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> retriever) {
        class ContextRetrievalCodec
        extends MapCodec<E> {
            final /* synthetic */ Function val$retriever;

            ContextRetrievalCodec(Function function) {
                this.val$retriever = function;
            }

            public <T> RecordBuilder<T> encode(E input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                return prefix;
            }

            public <T> DataResult<E> decode(DynamicOps<T> ops, MapLike<T> input) {
                return (DataResult)this.val$retriever.apply(ops);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + String.valueOf(this.val$retriever) + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.empty();
            }
        }
        return new ContextRetrievalCodec(retriever);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> typeGetter) {
        return collection -> {
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                Object object = typeGetter.apply(iterator.next());
                while (iterator.hasNext()) {
                    Object object1 = iterator.next();
                    Object object2 = typeGetter.apply(object1);
                    if (object2 == object) continue;
                    return DataResult.error(() -> "Mixed type list: element " + String.valueOf(object1) + " had type " + String.valueOf(object2) + ", but list is of type " + String.valueOf(object));
                }
            }
            return DataResult.success((Object)collection, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> catchDecoderException(final Codec<A> codec) {
        return Codec.of(codec, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T value) {
                try {
                    return codec.decode(ops, value);
                }
                catch (Exception var4) {
                    return DataResult.error(() -> "Caught exception decoding " + String.valueOf(value) + ": " + var4.getMessage());
                }
            }
        });
    }

    public static Codec<TemporalAccessor> temporalCodec(DateTimeFormatter dateTimeFormatter) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)dateTimeFormatter.parse((CharSequence)string));
            }
            catch (Exception var3) {
                return DataResult.error(var3::getMessage);
            }
        }, dateTimeFormatter::format);
    }

    public static MapCodec<OptionalLong> asOptionalLong(MapCodec<Optional<Long>> codec) {
        return codec.xmap(toOptionalLong, fromOptionalLong);
    }

    private static MapCodec<GameProfile> gameProfileCodec(Codec<UUID> idCodec) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)idCodec.fieldOf("id").forGetter(GameProfile::id), (App)PLAYER_NAME.fieldOf("name").forGetter(GameProfile::name), (App)PROPERTY_MAP.optionalFieldOf("properties", (Object)PropertyMap.EMPTY).forGetter(GameProfile::properties)).apply((Applicative)instance, GameProfile::new));
    }

    public static <K, V> Codec<Map<K, V>> sizeLimitedMap(Codec<Map<K, V>> mapCodec, int maxSize) {
        return mapCodec.validate(map -> map.size() > maxSize ? DataResult.error(() -> "Map is too long: " + map.size() + ", expected range [0-" + maxSize + "]") : DataResult.success((Object)map));
    }

    public static <T> Codec<Object2BooleanMap<T>> object2BooleanMap(Codec<T> codec) {
        return Codec.unboundedMap(codec, (Codec)Codec.BOOL).xmap(Object2BooleanOpenHashMap::new, Object2ObjectOpenHashMap::new);
    }

    @Deprecated
    public static <K, V> MapCodec<V> dispatchOptionalValue(final String key1, final String key2, final Codec<K> codec, final Function<? super V, ? extends K> keyGetter, final Function<? super K, ? extends Codec<? extends V>> codecGetter) {
        return new MapCodec<V>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of(ops.createString(key1), ops.createString(key2));
            }

            public <T> DataResult<V> decode(DynamicOps<T> ops, MapLike<T> input) {
                Object object = input.get(key1);
                return object == null ? DataResult.error(() -> "Missing \"" + key1 + "\" in: " + String.valueOf(input)) : codec.decode(ops, object).flatMap(pair -> {
                    Object object1 = Objects.requireNonNullElseGet(input.get(key2), () -> ((DynamicOps)ops).emptyMap());
                    return ((Codec)codecGetter.apply(pair.getFirst())).decode(ops, object1).map(Pair::getFirst);
                });
            }

            public <T> RecordBuilder<T> encode(V input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                Object object = keyGetter.apply(input);
                prefix.add(key1, codec.encodeStart(ops, object));
                DataResult<T> dataResult = this.encode((Codec)codecGetter.apply(object), input, ops);
                if (dataResult.result().isEmpty() || !Objects.equals(dataResult.result().get(), ops.emptyMap())) {
                    prefix.add(key2, dataResult);
                }
                return prefix;
            }

            private <T, V2 extends V> DataResult<T> encode(Codec<V2> valueCodec, V value, DynamicOps<T> ops) {
                return valueCodec.encodeStart(ops, value);
            }
        };
    }

    public static <A> Codec<Optional<A>> optionalEmptyMap(final Codec<A> codec) {
        return new Codec<Optional<A>>(){

            public <T> DataResult<Pair<Optional<A>, T>> decode(DynamicOps<T> ops, T input) {
                return 7.isEmptyMap(ops, input) ? DataResult.success((Object)Pair.of(Optional.empty(), input)) : codec.decode(ops, input).map(pair -> pair.mapFirst(Optional::of));
            }

            private static <T> boolean isEmptyMap(DynamicOps<T> ops, T value) {
                Optional optional = ops.getMap(value).result();
                return optional.isPresent() && ((MapLike)optional.get()).entries().findAny().isEmpty();
            }

            public <T> DataResult<T> encode(Optional<A> input, DynamicOps<T> ops, T value) {
                return input.isEmpty() ? DataResult.success((Object)ops.emptyMap()) : codec.encode(input.get(), ops, value);
            }
        };
    }

    @Deprecated
    public static <E extends Enum<E>> Codec<E> legacyEnum(Function<String, E> fromString) {
        return Codec.STRING.comapFlatMap(string -> {
            try {
                return DataResult.success((Object)((Enum)fromString.apply((String)string)));
            }
            catch (IllegalArgumentException var3) {
                return DataResult.error(() -> "No value with id: " + string);
            }
        }, Enum::toString);
    }

    public record StrictUnboundedMapCodec<K, V>(Codec<K> keyCodec, Codec<V> elementCodec) implements Codec<Map<K, V>>,
    BaseMapCodec<K, V>
    {
        public <T> DataResult<Map<K, V>> decode(DynamicOps<T> ops, MapLike<T> input) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Pair pair : input.entries().toList()) {
                DataResult dataResult1;
                DataResult dataResult = this.keyCodec().parse(ops, pair.getFirst());
                DataResult dataResult2 = dataResult.apply2stable(Pair::of, dataResult1 = this.elementCodec().parse(ops, pair.getSecond()));
                Optional optional = dataResult2.error();
                if (optional.isPresent()) {
                    String string = ((DataResult.Error)optional.get()).message();
                    return DataResult.error(() -> dataResult.result().isPresent() ? "Map entry '" + String.valueOf(dataResult.result().get()) + "' : " + string : string);
                }
                if (!dataResult2.result().isPresent()) {
                    return DataResult.error(() -> "Empty or invalid map contents are not allowed");
                }
                Pair pair1 = (Pair)dataResult2.result().get();
                builder.put(pair1.getFirst(), pair1.getSecond());
            }
            ImmutableMap map = builder.build();
            return DataResult.success((Object)map);
        }

        public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
            return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(mapLike -> this.decode(ops, (Object)mapLike)).map(map -> Pair.of((Object)map, (Object)input));
        }

        public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T value) {
            return this.encode(input, ops, ops.mapBuilder()).build(value);
        }

        @Override
        public String toString() {
            return "StrictUnboundedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
        }
    }

    public record TagOrElementLocation(Identifier id, boolean tag) {
        @Override
        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag ? ExtraCodecs.HEX_COLOR_PREFIX + String.valueOf(this.id) : this.id.toString();
        }
    }

    public static class LateBoundIdMapper<I, V> {
        private final BiMap<I, V> idToValue = HashBiMap.create();

        public Codec<V> codec(Codec<I> idCodec) {
            BiMap map = this.idToValue.inverse();
            return ExtraCodecs.idResolverCodec(idCodec, arg_0 -> this.idToValue.get(arg_0), arg_0 -> map.get(arg_0));
        }

        public LateBoundIdMapper<I, V> put(I id, V value) {
            Objects.requireNonNull(value, () -> "Value for " + String.valueOf(id) + " is null");
            this.idToValue.put(id, value);
            return this;
        }

        public Set<V> values() {
            return Collections.unmodifiableSet(this.idToValue.values());
        }
    }
}

